import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "stacked"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
var ButtonSet = /*#__PURE__*/React.forwardRef(function ButtonSet(_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      stacked = _ref.stacked,
      rest = _objectWithoutProperties(_ref, _excluded);

  var buttonSetClasses = classNames(className, "".concat(prefix, "--btn-set"), _defineProperty({}, "".concat(prefix, "--btn-set--stacked"), stacked));
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: buttonSetClasses,
    ref: ref
  }), children);
});
ButtonSet.displayName = 'ButtonSet';
ButtonSet.propTypes = {
  /**
   * Specify the content of your ButtonSet
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be added to your ButtonSet
   */
  className: PropTypes.string,

  /**
   * Specify the button arrangement of the set (vertically stacked or
   * horizontal)
   */
  stacked: PropTypes.bool
};
export default ButtonSet;