import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import { Breadcrumb, BreadcrumbItem, BreadcrumbSkeleton } from '../Breadcrumb';
import OverflowMenu from '../OverflowMenu';
import OverflowMenuItem from '../OverflowMenuItem';
import mdx from './Breadcrumb.mdx';
export default {
  title: 'Components/Breadcrumb',
  component: Breadcrumb,
  subcomponents: {
    BreadcrumbItem: BreadcrumbItem,
    BreadcrumbSkeleton: BreadcrumbSkeleton
  },
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var breadcrumb = function breadcrumb() {
  return /*#__PURE__*/React.createElement(Breadcrumb, null, /*#__PURE__*/React.createElement(BreadcrumbItem, null, /*#__PURE__*/React.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 3"), /*#__PURE__*/React.createElement(BreadcrumbItem, null, "Breadcrumb 4"));
};
export var breadcrumbWithOverflowMenu = function breadcrumbWithOverflowMenu() {
  return /*#__PURE__*/React.createElement(Breadcrumb, null, /*#__PURE__*/React.createElement(BreadcrumbItem, null, /*#__PURE__*/React.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    "data-floating-menu-container": true
  }, /*#__PURE__*/React.createElement(OverflowMenu, null, /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Breadcrumb 3"
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Breadcrumb 4"
  }))), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 5"), /*#__PURE__*/React.createElement(BreadcrumbItem, null, "Breadcrumb 6"));
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement(BreadcrumbSkeleton, null);
};

var props = function props() {
  return {
    className: 'some-class',
    noTrailingSlash: boolean('No trailing slash (noTrailingSlash)', false),
    onClick: action('onClick')
  };
};

export var playground = function playground() {
  return /*#__PURE__*/React.createElement(Breadcrumb, props(), /*#__PURE__*/React.createElement(BreadcrumbItem, null, /*#__PURE__*/React.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/React.createElement(BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/React.createElement(BreadcrumbItem, _extends({
    href: "#"
  }, props(), {
    isCurrentPage: boolean('Is current page (isCurrentPage)', false)
  }), "Breadcrumb 3"), /*#__PURE__*/React.createElement(BreadcrumbItem, null, "Breadcrumb 4"));
};