import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
var _excluded = ["children", "className", "iconDescription", "open", "onHeadingClick", "renderExpando", "title", "disabled"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { ChevronRight16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useState } from 'react';
import { Text } from '../Text';
import { match, keys } from '../../internal/keyboard';
import { useId } from '../../internal/useId';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;

var defaultRenderExpando = function defaultRenderExpando(props) {
  return /*#__PURE__*/React.createElement("button", _extends({
    type: "button"
  }, props));
};

function AccordionItem(_ref) {
  var _cx;

  var children = _ref.children,
      customClassName = _ref.className,
      iconDescription = _ref.iconDescription,
      _ref$open = _ref.open,
      open = _ref$open === void 0 ? false : _ref$open,
      onHeadingClick = _ref.onHeadingClick,
      _ref$renderExpando = _ref.renderExpando,
      Expando = _ref$renderExpando === void 0 ? defaultRenderExpando : _ref$renderExpando,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'title' : _ref$title,
      disabled = _ref.disabled,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(open),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = useState(open),
      _useState4 = _slicedToArray(_useState3, 2),
      prevIsOpen = _useState4[0],
      setPrevIsOpen = _useState4[1];

  var _useState5 = useState(''),
      _useState6 = _slicedToArray(_useState5, 2),
      animation = _useState6[0],
      setAnimation = _useState6[1];

  var id = useId('accordion-item');
  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--accordion__item"), true), _defineProperty(_cx, "".concat(prefix, "--accordion__item--active"), isOpen), _defineProperty(_cx, "".concat(prefix, "--accordion__item--").concat(animation), animation), _defineProperty(_cx, "".concat(prefix, "--accordion__item--disabled"), disabled), _defineProperty(_cx, customClassName, !!customClassName), _cx));

  if (open !== prevIsOpen) {
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(open);
    setPrevIsOpen(open);
  } // When the AccordionItem heading is clicked, toggle the open state of the
  // panel


  function onClick(event) {
    var nextValue = !isOpen;
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(nextValue);

    if (onHeadingClick) {
      // TODO: normalize signature, potentially:
      // onHeadingClick :: (event: Event, state: { isOpen: Boolean }) => any
      onHeadingClick({
        isOpen: nextValue,
        event: event
      });
    }
  } // If the AccordionItem is open, and the user hits the ESC key, then close it


  function onKeyDown(event) {
    if (isOpen && match(event, keys.Escape)) {
      setIsOpen(false);
    }
  }

  function handleAnimationEnd(event) {
    if (rest.handleAnimationEnd) {
      rest.handleAnimationEnd(event);
    }

    setAnimation('');
  }

  return /*#__PURE__*/React.createElement("li", _extends({
    className: className
  }, rest, {
    onAnimationEnd: handleAnimationEnd
  }), /*#__PURE__*/React.createElement(Expando, {
    disabled: disabled,
    "aria-controls": id,
    "aria-expanded": isOpen,
    className: "".concat(prefix, "--accordion__heading"),
    onClick: onClick,
    onKeyDown: onKeyDown,
    type: "button"
  }, /*#__PURE__*/React.createElement(ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/React.createElement(Text, {
    as: "div",
    className: "".concat(prefix, "--accordion__title")
  }, title)), /*#__PURE__*/React.createElement("div", {
    id: id,
    className: "".concat(prefix, "--accordion__content")
  }, children));
}

AccordionItem.propTypes = {
  /**
   * Provide the contents of your AccordionItem
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether an individual AccordionItem should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * The description of the expando icon.
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop has been deprecated as it is no longer ' + 'required. Feel free to remove this prop from <AccordionItem>. This ' + 'prop will be removed in the next major release of ' + '`carbon-components-react`'),

  /**
   * The handler of the massaged `click` event.
   */
  onClick: PropTypes.func,

  /**
   * The handler of the massaged `click` event on the heading.
   */
  onHeadingClick: PropTypes.func,

  /**
   * `true` to open the expando.
   */
  open: PropTypes.bool,

  /**
   * The callback function to render the expando button.
   * Can be a React component class.
   */
  renderExpando: PropTypes.func,

  /**
   * The accordion title.
   */
  title: PropTypes.node
};
export default AccordionItem;