# carbon-components-react

> A collection of
> [Carbon Components](https://github.com/carbon-design-system/carbon/tree/main/packages/components)
> built with [React](https://reactjs.org/).

If you're new to React.js or Carbon, check out our
[guide](https://medium.com/carbondesign/up-running-with-carbon-react-in-less-than-5-minutes-25d43cca059e)
to help get you up and running.

## Getting started

To install `carbon-components-react` in your project, you will need to run the
following command using [npm](https://www.npmjs.com/):

```bash
npm install -S carbon-components carbon-components-react carbon-icons
```

If you prefer [Yarn](https://yarnpkg.com/en/), use the following command
instead:

```bash
yarn add carbon-components carbon-components-react carbon-icons
```

If you want to try out `carbon-components-react`, you can also use
[CodeSandbox](https://codesandbox.io/s/github/carbon-design-system/carbon/tree/main/packages/react/examples/codesandbox).

[![Edit carbon-components-react](https://codesandbox.io/static/img/play-codesandbox.svg)](https://codesandbox.io/s/github/carbon-design-system/carbon/tree/main/packages/react/examples/codesandbox)

## Usage

```js
import { Button } from 'carbon-components-react';

function MyComponent() {
  return <Button>Example usage</Button>;
}
```

For more information about each component, check out our
[Storybook](https://react.carbondesignsystem.com). For guides on getting
started, head on over to our
[Website](https://www.carbondesignsystem.com/get-started/develop/react) or check
out our
[Tutorial](https://www.carbondesignsystem.com/developing/react-tutorial/overview/)

# :books: Documentation

- [Storybook](https://react.carbondesignsystem.com)
- [Getting started](https://www.carbondesignsystem.com/get-started/develop/react)
- [🏃‍♀️ Migration Guides](./docs/migration)
  - [v6 to v7](./docs/migration/migrate-to-7.x.md)

## 📚 Examples

If you're looking for more examples on how to use `carbon-components-react`, we
have some examples that you can check out:

- [Create React App](./examples/create-react-app)
- [Next.js](./examples/next)
- [React Router](./examples/react-router)

## 🙌 Contributing

We're always looking for contributors to help us fix bugs, build new features,
or help us improve the project documentation. If you're interested, definitely
check out our [Contributing Guide](/.github/CONTRIBUTING.md)! 👀

## 📝 License

Licensed under the [Apache 2.0 License](/LICENSE).
