import { Arguments, Table } from '@kui-shell/core';
import { KubeOptions } from '@kui-shell/plugin-kubectl';
/**
 *
 */
interface PodOptions extends KubeOptions {
    node?: string;
    containers?: boolean;
}
/**
 * Command handler for `kubectl top pod` (overrides built-in functionality)
 *
 */
export declare function topPod(args: Arguments<PodOptions>, top: (args: Arguments<KubeOptions>) => Promise<Table>): Promise<Table>;
/**
 * Command handler for `kubectl top container`
 *
 */
export declare function topContainer(args: Arguments<PodOptions>): Promise<Table>;
export {};
