"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _ = require("..");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugin-view-utilization/widgets/cluster-utilization');

class ClusterUtilization extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      cpuFrac: 0,
      memFrac: 0,
      viewLevel: 'hidden'
    };
  }

  reportClusterUtilization() {
    return __awaiter(this, void 0, void 0, function* () {
      try {
        const tab = (0, _core.getCurrentTab)();
        const {
          content: info
        } = yield tab.REPL.rexec('kubectl top node-summary');
        this.setState({
          cpuFrac: info.cpuFrac,
          memFrac: info.memFrac,
          viewLevel: 'normal' // only show normally if we succeed; see https://github.com/IBM/kui/issues/3537

        });
      } catch (err) {
        debug(err);
        this.setState({
          cpuFrac: 0,
          memFrac: 0,
          viewLevel: 'hidden'
        });
      }
    });
  }
  /**
   * Once we have mounted, we immediately check the current cpu utilization,
   * and schedule an update based on standard REPL events.
   *
   */


  componentDidMount() {
    this.reportClusterUtilization();
    (0, _core.wireToStandardEvents)(this.reportClusterUtilization.bind(this));
  }

  render() {
    return React.createElement(_pluginClientCommon.TextWithIconWidget, {
      text: "",
      viewLevel: this.state.viewLevel,
      id: "kui--plugin-view-utilization--cluster-utilization"
    }, React.createElement(_.BarContainer, {
      onClick: "kubectl top node"
    }, React.createElement(_.Bar, {
      color: "var(--color-latency-0)"
      /* CPU */
      ,
      fraction: this.state.cpuFrac
    }), React.createElement(_.Bar, {
      color: "var(--color-latency-1)"
      /* Memory */
      ,
      fraction: this.state.memFrac
    })));
  }

}

exports.default = ClusterUtilization;