import { ModeRegistration } from '@kui-shell/core';
import { WithRawData } from '../../model/resource';
/** Mode identifier */
export declare const mode = "raw";
/** Mode label; intentionally no i18n */
export declare const label = "YAML";
/** We want this to be placed as the last tab */
export declare const order = 999;
/**
 * The YAML mode applies to all KubeResources, and simply extracts the
 * raw `data` field from the resource; note how we indicate that this
 * raw data has a yaml content type.
 *
 */
declare const yamlMode: ModeRegistration<WithRawData>;
export default yamlMode;
