export { KubeResource, isKubeResource, isCrudableKubeResource, KubeResourceWithSummary, WithSummary, WithRawData, InvolvedObject, KubeStatus, KubeStatusCondition, Pod, isPod, Deployment, isDeployment, KubeItems, isKubeItems, isKubeItemsOfKind, KubeContext, Job, isJob, Resource } from './lib/model/resource';
export { default as TrafficLight } from './lib/model/traffic-light';
export { default as apiVersion } from './controller/kubectl/apiVersion';
export { default as doExecWithMarkdown } from './controller/kubectl/exec-to-markdown';
export { doExecWithStdoutViaPty, doExecWithPty, doExecWithStdout, doExecWithStatus, doExecWithRadioTable, doExecWithTable } from './controller/kubectl/exec';
export { doExecRaw, doNativeExec } from './controller/kubectl/raw';
export { default as commandPrefix } from './controller/command-prefix';
export { default as defaultFlags, crudFlags, flags } from './controller/kubectl/flags';
export { getCurrentContext, getCurrentContextName, getCurrentDefaultNamespace } from './controller/kubectl/contexts';
export { KubeOptions, hasLabel, getLabel, getLabelForArgv, isHelpRequest, getContainer, getNamespace, isForAllNamespaces } from './controller/kubectl/options';
export { default as parseName } from './lib/util/name';
export { stringToTable, formatTable, preprocessTable } from './lib/view/formatTable';
export { isUsage, doHelp } from './lib/util/help';
export { getCommandFromArgs } from './lib/util/util';
export { fetchFileString } from './lib/util/fetch-file';
export { fqnOf, fqn } from './controller/kubectl/fqn';
/**
 * Exports for future delegation; e.g. `oc get pods` is mostly just
 * `kubectl get pods`
 *
 */
export { register as registerEdit } from './controller/kubectl/edit';
export { doGet, getter } from './controller/kubectl/get';
export { doRun } from './controller/kubectl/run';
export { doCreate } from './controller/kubectl/create';
export { doDelete } from './controller/kubectl/delete';
export { describer } from './controller/kubectl/describe';
export { register as registerConfig } from './controller/kubectl/config';
export { registerApplySubcommands } from './controller/kubectl/apply-subcommands';
export { viewTransformer as getTransformer } from './controller/kubectl/get';
export { viewTransformer as getNamespacesTransformer } from './controller/kubectl/get-namespaces';
/** A channel that covers *possible* changes to kubectl config */
export { onKubectlConfigChangeEvents, offKubectlConfigChangeEvents, emitKubectlConfigChangeEvent } from './controller/kubectl/config';
/** memory and cpu parsing */
export { default as Parser } from './lib/util/parse';
