import { ExecOptions, Registrar } from '@kui-shell/core';
import RawResponse from './response';
import { KubeOptions } from './options';
/** this is the subset of Commands.Arguments that we need */
interface Arguments {
    command: string;
    argv: string[];
    parsedOptions: KubeOptions;
    execOptions: ExecOptions;
}
/**
 * This is the final bottoming out of the exec/spawn of the native
 * executable.
 *
 */
export declare const doNativeExec: (args: Arguments) => Promise<RawResponse>;
/**
 * A convenience wrapper over `doNativeExec` that extracts only
 * stdout, and discards the exit code and stderr.
 *
 */
export declare function doExecRaw(command: string, parsedOptions: KubeOptions, execOptions: ExecOptions): Promise<string>;
declare const _default: (registrar: Registrar) => Promise<void>;
export default _default;
