/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getCurrentDefaultNamespace } from './contexts';
export function fileOf(args) {
    return args.parsedOptions.f || args.parsedOptions.filename;
}
export function kustomizeOf(args) {
    return args.parsedOptions.k || args.parsedOptions.kustomize;
}
export function getFileForArgv(args, addSpace = false) {
    const file = fileOf(args);
    if (file) {
        return `-f ${file}${addSpace ? ' ' : ''}`;
    }
    else {
        const kusto = kustomizeOf(args);
        if (kusto) {
            return `-k ${kusto}${addSpace ? ' ' : ''}`;
        }
    }
    return '';
}
export function formatOf(args) {
    return args.parsedOptions.o || args.parsedOptions.output;
}
export function isEntityFormat(format) {
    return format === 'yaml' || format === 'json';
}
export function isEntityRequest(args) {
    return isEntityFormat(formatOf(args));
}
/**
 * Notes: we interpret the lack of an output format designation as a
 * request for tabular output. This seems in keeping with the
 * `kubectl` behavior.
 *
 * @return truthy if the format indicates a desire for tabular output
 *
 */
function isTableFormat(format) {
    return !format || format === 'wide' || /^custom-columns=/.test(format) || /^custom-columns-file=/.test(format);
}
export function isDashHelp(args) {
    return args.parsedOptions.help || args.parsedOptions.h;
}
export function isHelpRequest(args) {
    return (isDashHelp(args) || args.argvNoOptions[1] === 'help' || args.argvNoOptions[1] === 'options' // usage: `kubectl options`
    );
}
export function isTableRequest(args) {
    return isTableFormat(formatOf(args));
}
export function isWatchRequest(args) {
    return args.parsedOptions.w || args.parsedOptions.watch || args.parsedOptions['watch-only'];
}
export function isTableWatchRequest(args) {
    return isWatchRequest(args) && isTableRequest(args);
}
export function getLabel(args) {
    const label = args.parsedOptions.l || args.parsedOptions.label;
    if (label) {
        return label;
    }
    else {
        // yargs-parser doesn't handle -lname=nginx without the space
        // after -l; or least not the way we've configured it
        for (const key in args.parsedOptions) {
            if (/^l/.test(key)) {
                const value = args.parsedOptions[key];
                return `${key.slice(1)}=${value}`;
            }
        }
    }
}
export function getLabelForArgv(args) {
    const label = getLabel(args);
    if (label) {
        return `-l ${label}`;
    }
    else {
        return '';
    }
}
/**
 * Due to deficiencies in yargs-parser (used by @kui-shell/core), the
 * form -lapp=name (i.e. without a whitespace after the -l) is not
 * parsed properly.
 */
export function hasLabel(args) {
    if (args.parsedOptions.l || args.parsedOptions.label) {
        return true;
    }
    for (const key in args.parsedOptions) {
        if (/^l/.test(key)) {
            return true;
        }
    }
    return false;
}
/** @return the namespace as expressed in the command line, or undefined if not */
export function getNamespaceAsExpressed(args) {
    return args.parsedOptions.n || args.parsedOptions.namespace;
}
/** @return the namespace as expressed in the command line, or the default from context */
export function getNamespace(args) {
    return __awaiter(this, void 0, void 0, function* () {
        return args.parsedOptions.n || args.parsedOptions.namespace || (yield getCurrentDefaultNamespace(args));
    });
}
/**
 * A variant of getNamespace where you *only* want to use what was
 * provided by the user in their command line.
 */
export function getNamespaceForArgv(args) {
    const ns = args.parsedOptions.n || args.parsedOptions.namespace;
    return !ns ? '' : `-n ${ns}`;
}
export function getContext(args) {
    return args.parsedOptions.context;
}
/** e.g. for kubectl logs */
export function getContainer(args, verb) {
    const maybe = args.parsedOptions.c || args.parsedOptions.container;
    if (maybe) {
        // specified via -c
        return maybe;
    }
    else {
        // otherwise, specified as a positional parameter
        const idx = args.argvNoOptions.indexOf(verb);
        return args.argvNoOptions[idx + 2];
    }
}
export function getContextForArgv(args) {
    const context = getContext(args);
    if (context) {
        return `--context ${context}`;
    }
    else {
        return '';
    }
}
export function isForAllNamespaces(parsedOptions) {
    return parsedOptions.A || parsedOptions['all-namespaces'];
}
//# sourceMappingURL=options.js.map