import { KubeResource } from '../../lib/model/resource';
/**
 * A way to uniquely identify a resource in a cluster
 *
 */
export interface ResourceRef {
    group?: string;
    version?: string;
    kind: string;
    name: string;
    namespace: string;
}
/**
 * Extract the group and version from an `apiVersion` string
 *
 */
export declare function versionOf(apiVersion: string): {
    group: string;
    version: string;
};
export declare function kindPart(apiVersion: string, kind: string): string;
export declare function kindPartOf(resource: KubeResource): string;
export declare function kindAndNamespaceOf(resource: KubeResource): string;
export declare function fqn(apiVersion: string, kind: string, name: string, namespace: string): string;
export declare function fqnOf(resource: KubeResource): string;
export declare function fqnOfRef({ group, version, kind, name, namespace }: ResourceRef): string;
export default fqn;
