/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { isTable } from '@kui-shell/core';
import flags from './flags';
import { exec } from './exec';
import commandPrefix from '../command-prefix';
import { stringToTable } from '../../lib/view/formatTable';
import { isUsage, doHelp } from '../../lib/util/help';
export const doGet = (command) => (args) => __awaiter(void 0, void 0, void 0, function* () {
    if (isUsage(args)) {
        return doHelp(command, args);
    }
    else {
        // first, we do the raw exec of the given command
        const response = yield exec(args, undefined, command);
        const { content: { stderr, stdout } } = response;
        const table = yield stringToTable(stdout, stderr, args, command, 'explain', 'api-resources');
        if (isTable(table)) {
            table.body.forEach(_ => {
                const name = (_.attributes[3] && _.attributes[3].value) || _.name;
                _.onclick = `${command} explain ${name}`;
            });
            table.body.sort((a, b) => a.name.localeCompare(b.name));
        }
        return table;
    }
});
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/kubectl/api-resources`, doGet('kubectl'), flags);
    registrar.listen(`/${commandPrefix}/k/api-resources`, doGet('kubectl'), flags);
};
//# sourceMappingURL=api-resources.js.map