"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _help = _interopRequireDefault(require("./controller/help"));

var _info = _interopRequireDefault(require("./controller/info"));

var _list = _interopRequireDefault(require("./controller/list"));

var _genericTable = _interopRequireDefault(require("./controller/generic-table"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const aliases = ['k', 'kubectl'];
const canonical = 'kubectl';

var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  aliases.forEach(command => {
    registrar.listen(`/${_pluginKubectl.commandPrefix}/${command}/krew/help`, (0, _help.default)(canonical), _pluginKubectl.defaultFlags);
    registrar.listen(`/${_pluginKubectl.commandPrefix}/${command}/krew/info`, (0, _info.default)(canonical), _pluginKubectl.defaultFlags);
    registrar.listen(`/${_pluginKubectl.commandPrefix}/${command}/krew/list`, (0, _list.default)(canonical), _pluginKubectl.defaultFlags);
    registrar.listen(`/${_pluginKubectl.commandPrefix}/${command}/krew/search`, (0, _genericTable.default)(canonical), _pluginKubectl.defaultFlags);
    registrar.listen(`/${_pluginKubectl.commandPrefix}/${command}/krew/version`, (0, _genericTable.default)(canonical), _pluginKubectl.defaultFlags);
  });
});

exports.default = _default;