"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SidecarForm;
exports.FormWithLabels = FormWithLabels;
exports.renderFormWithLabels = renderFormWithLabels;
exports.renderForm = renderForm;

var React = _interopRequireWildcard(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** @return a ReactElement */
function SidecarForm({
  nested,
  map,
  className
}) {
  return React.createElement("div", {
    className: "kui--form-section"
  }, React.createElement(_carbonComponentsReact.Form, {
    className: nested ? className : `padding-content scrollable ${className || ''}`
  }, Object.keys(map).map((key, idx) => {
    const vvalue = map[key];
    const value = (typeof vvalue === 'number' ? vvalue.toLocaleString() : typeof vvalue !== 'object' ? vvalue : vvalue.label) || '';
    const colspan = Math.max(Math.ceil(key.length / 8), Math.ceil((value.length + 3) / 5.5));
    const style = {
      gridColumn: `span ${colspan > 15 ? 8 : colspan}`
    };
    const className = typeof vvalue !== 'object' ? undefined : 'kui--form-item--for-label';
    return React.createElement("div", {
      key: idx,
      style: style,
      className: className
    }, colspan > 15 ? React.createElement(_carbonComponentsReact.TextArea, {
      readOnly: true,
      id: `kubectl-summary-${key}`,
      labelText: key,
      defaultValue: value
    }) : React.createElement(_carbonComponentsReact.TextInput, {
      readOnly: true,
      id: `kubectl-summary-${key}`,
      labelText: key,
      defaultValue: value
    }));
  })));
}

function FormWithLabels(props) {
  const labelMap = {};
  let nLabels = 0;

  if (props.resource.metadata && props.resource.metadata.labels) {
    for (const key in props.resource.metadata.labels) {
      nLabels++;
      labelMap[`${key} label`] = {
        label: props.resource.metadata.labels[key]
      };
    }
  }

  return React.createElement("div", {
    className: "padding-content scrollable"
  }, React.createElement(SidecarForm, {
    nested: true,
    map: props.map
  }), nLabels > 0 && React.createElement(SidecarForm, {
    nested: true,
    map: labelMap
  }));
}

function renderFormWithLabels(map, resource) {
  return {
    react: function SidecarFormWithLabelsProvider() {
      return React.createElement(FormWithLabels, {
        map: map,
        resource: resource
      });
    }
  };
}
/** @return a ReactProvider */


function renderForm(map) {
  return {
    react: function SidecarFormProvider() {
      return React.createElement(SidecarForm, {
        map: map
      });
    }
  };
}