"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectorTabbable = exports.DOCUMENT_POSITION_BROAD_FOLLOWING = exports.DOCUMENT_POSITION_BROAD_PRECEDING = exports.getNextIndex = void 0;

var _keys = require("./keys");

var _match = require("./match");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Various utilities to help with a11y work
 */

/**
 * A "ring buffer" function that takes an array and depending on an ArrowRight
 * or ArrowLeft key input loops from last index to first or first index to last.
 *
 * @param {string} key - the left or right arrow keys
 * @param {number} index - the current index in a given array
 * @param {number} arrayLength - the total length of the array
 *
 * @example
 * 	getNextIndex(keyCodes.RIGHT, 0, 4)
 */
var getNextIndex = function getNextIndex(key, index, arrayLength) {
  if ((0, _match.match)(key, _keys.ArrowRight)) {
    return (index + 1) % arrayLength;
  }

  if ((0, _match.match)(key, _keys.ArrowLeft)) {
    return (index + arrayLength - 1) % arrayLength;
  }
};
/**
 * A flag `node.compareDocumentPosition(target)` returns,
 * that indicates `target` is located earlier than `node` in the document or `target` contains `node`.
 */


exports.getNextIndex = getNextIndex;
var DOCUMENT_POSITION_BROAD_PRECEDING = // Checks `typeof Node` for `react-docgen`
typeof Node !== 'undefined' && Node.DOCUMENT_POSITION_PRECEDING | Node.DOCUMENT_POSITION_CONTAINS;
/**
 * A flag `node.compareDocumentPosition(target)` returns,
 * that indicates `target` is located later than `node` in the document or `node` contains `target`.
 */

exports.DOCUMENT_POSITION_BROAD_PRECEDING = DOCUMENT_POSITION_BROAD_PRECEDING;
var DOCUMENT_POSITION_BROAD_FOLLOWING = // Checks `typeof Node` for `react-docgen`
typeof Node !== 'undefined' && Node.DOCUMENT_POSITION_FOLLOWING | Node.DOCUMENT_POSITION_CONTAINED_BY;
/**
 * CSS selector that selects major nodes that is sequential-focusable.
 */

exports.DOCUMENT_POSITION_BROAD_FOLLOWING = DOCUMENT_POSITION_BROAD_FOLLOWING;
var selectorTabbable = "\n  a[href], area[href], input:not([disabled]):not([tabindex='-1']),\n  button:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),\n  textarea:not([disabled]):not([tabindex='-1']),\n  iframe, object, embed, *[tabindex]:not([tabindex='-1']), *[contenteditable=true]\n";
exports.selectorTabbable = selectorTabbable;