function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import Button from '../Button';
import TableActionList from './TableActionList';
var prefix = settings.prefix;
var translationKeys = {
  'carbon.table.batch.cancel': 'Cancel',
  'carbon.table.batch.items.selected': 'items selected',
  'carbon.table.batch.item.selected': 'item selected'
};

var translateWithId = function translateWithId(id, state) {
  if (id === 'carbon.table.batch.cancel') {
    return translationKeys[id];
  }

  return "".concat(state.totalSelected, " ").concat(translationKeys[id]);
};

var TableBatchActions = function TableBatchActions(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      shouldShowBatchActions = _ref.shouldShowBatchActions,
      totalSelected = _ref.totalSelected,
      onCancel = _ref.onCancel,
      t = _ref.translateWithId,
      rest = _objectWithoutProperties(_ref, ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"]);

  var batchActionsClasses = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--batch-actions"), true), _defineProperty(_cx, "".concat(prefix, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
  return React.createElement("div", _extends({}, rest, {
    className: batchActionsClasses
  }), React.createElement(TableActionList, null, children, React.createElement(Button, {
    className: "".concat(prefix, "--batch-summary__cancel"),
    tabIndex: shouldShowBatchActions ? 0 : -1,
    onClick: onCancel
  }, t('carbon.table.batch.cancel'))), React.createElement("div", {
    className: "".concat(prefix, "--batch-summary")
  }, React.createElement("p", {
    className: "".concat(prefix, "--batch-summary__para")
  }, React.createElement("span", null, totalSelected > 1 ? t('carbon.table.batch.items.selected', {
    totalSelected: totalSelected
  }) : t('carbon.table.batch.item.selected', {
    totalSelected: totalSelected
  })))));
};

TableBatchActions.translationKeys = Object.keys(translationKeys);
TableBatchActions.propTypes = {
  children: PropTypes.node,
  className: PropTypes.string,

  /**
   * Boolean specifier for whether or not the batch action bar should be
   * displayed
   */
  shouldShowBatchActions: PropTypes.bool,

  /**
   * Numeric representation of the total number of items selected in a table.
   * This number is used to derive the selection message
   */
  totalSelected: PropTypes.number.isRequired,

  /**
   * Hook required to listen for when the user initiates a cancel request
   * through this comopnent
   */
  onCancel: PropTypes.func.isRequired,

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are avabile on the `translationKeys` field for
   * this component.
   */
  translateWithId: PropTypes.func
};
TableBatchActions.defaultProps = {
  translateWithId: translateWithId
};
export default TableBatchActions;