var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { inBrowser } from '@kui-shell/core';
let staticConfig;
if (process.env.NODE_ENV === 'development') {
    staticConfig = require('./search.json');
}
const getXsrfToken = () => {
    const token = document.querySelector('#app-access') ? document.querySelector('#app-access')['value'] : '';
    return token.toString('ascii');
};
export function getConfig() {
    return __awaiter(this, void 0, void 0, function* () {
        const nconf = require('nconf');
        const WHITELIST = ['contextPath'];
        let config = Object.assign({
            env: '',
            SEARCH_API: staticConfig
                ? staticConfig.SEARCH_API
                : `${window && window.location && window.location.origin}/multicloud/search/graphql`,
            CONSOLE_API: staticConfig
                ? staticConfig.CONSOLE_API
                : `${window && window.location && window.location.origin}/multicloud/graphql`,
        }, {
            xsrfToken: inBrowser() ? getXsrfToken() : null,
            authorization: 'Bearer ',
            cookie: 'cfc-cookie-access-token=',
        });
        if (process.env.NODE_ENV === 'development') {
            try {
                const authConfig = require('./search-auth.json');
                if (authConfig.authorization) {
                    config.authorization = authConfig.authorization;
                    config.cookie = authConfig.cookie;
                }
            }
            catch (err) {
                console.error(err);
            }
        }
        if (nconf) {
            WHITELIST.forEach(i => {
                config[i] = nconf.get(i);
            });
            if (process.env.NODE_ENV) {
                config.env = process.env.NODE_ENV;
            }
        }
        else {
            const configElement = document.getElementById('config');
            config = (configElement && JSON.parse(configElement.textContent)) || {};
        }
        return config;
    });
}
export default getConfig;
//# sourceMappingURL=config.js.map