var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import HTTPClient from './HTTPClient';
import renderReact from '../util/renderReact';
import { convertStringToQuery } from '../util/search-helper';
import { usage } from './helpfiles/searchhelp';
import { SEARCH_RELATED_QUERY } from '../definitions/search-queries';
import { getSidecar } from './sidecar';
import strings from '../util/i18n';
import { getPluginState, setPluginState, resourceNotFound } from '../pluginState';
import Modal from '../components/Modal';
import { searchDelete } from './actionHandler';
export const renderSearchAvailable = () => {
    const node = document.createElement('div');
    node.classList.add('is-search-available');
    const status = () => {
        return (React.createElement("div", null,
            React.createElement("p", null,
                React.createElement("span", { className: 'oops' }, strings('search.service.installed.error')))));
    };
    ReactDOM.render(React.createElement(status), node);
    return node;
};
export const doSearch = (args) => {
    const { argv, command } = args;
    const flags = getPluginState().flags;
    if (argv.length === 1 || flags.includes(argv[1])) {
        return usage(argv);
    }
    return new Promise((resolve) => {
        if (command.includes('--related')) {
            resolve(getSidecar(args));
        }
        const userQuery = convertStringToQuery(command);
        if (command.includes('--save') && argv.indexOf('--save') === argv.length - 1) {
            const node = document.createElement('div');
            const save = () => {
                return (React.createElement(Modal, { item: args, modalOpen: true, onClose: false, action: 'save' }));
            };
            ReactDOM.render(React.createElement(save), node);
            resolve(node);
        }
        if (command.includes('search -delete')) {
            resolve(searchDelete(args));
        }
        const buildTable = (data) => {
            const node = document.createElement('div', { is: 'react-entry-point' });
            node.classList.add('search-kui-plugin');
            data.items.length > 0
                ? renderReact(data, node, command)
                : node.appendChild(resourceNotFound());
            return node;
        };
        HTTPClient('post', 'search', SEARCH_RELATED_QUERY(userQuery.keywords, userQuery.filters))
            .then((res) => {
            resolve(buildTable(res.data.searchResult[0]));
        })
            .catch((err) => {
            setPluginState('error', err);
            resolve(renderSearchAvailable());
        });
    });
};
export default (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const searchCmd = commandTree.listen('/search', doSearch);
    commandTree.synonym('/s', doSearch, searchCmd);
    const summaryCmd = yield commandTree.listen('/search/summary', getSidecar);
    commandTree.synonym('/s/summary', getSidecar, summaryCmd);
});
//# sourceMappingURL=search.js.map