import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { getCurrentTab } from '@kui-shell/core';
import { Copy24 } from '@carbon/icons-react';
export const getTableContent = (data) => {
    const node = document.createElement('div');
    node.classList.add('bx--data-table-container');
    const content = () => {
        return (React.createElement("table", { className: "bx--data-table bx--data-table--short bx--data-table--no-border" },
            React.createElement("thead", null,
                React.createElement("tr", { className: "bx--data-table--compact" }, data.headers.map((res) => {
                    return (React.createElement("th", { key: res.key }, res.header.toUpperCase()));
                }))),
            React.createElement("tbody", null, data.rows.map((res) => {
                return (React.createElement("tr", { className: "bx--data-table--compact", key: res.name },
                    React.createElement("td", { onClick: () => getCurrentTab().REPL.pexec(res.command) }, res.name),
                    React.createElement("td", null, res.docs)));
            }))));
    };
    ReactDOM.render(React.createElement(content), node);
    return node;
};
export const getIntroduction = (data) => {
    const node = document.createElement('div');
    const content = () => {
        return (React.createElement("div", null, data.map((res) => {
            return (React.createElement("div", { key: res.header },
                React.createElement("h3", { className: `${res.header.toLowerCase()}-header` },
                    React.createElement("strong", null, res.header)),
                React.createElement("p", null, res.docs),
                res.usage ? React.createElement("div", { className: 'bx--snippet bx--snippet--single search' },
                    res.usage,
                    React.createElement(Copy24, { className: 'copy-btn' })) : null));
        })));
    };
    ReactDOM.render(React.createElement(content), node);
    return node;
};
//# sourceMappingURL=search-sidecar-help.js.map