"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntroduction = exports.getTableContent = void 0;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _core = require("@kui-shell/core");

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const getTableContent = data => {
  const node = document.createElement('div');
  node.classList.add('bx--data-table-container');

  const content = () => {
    return /*#__PURE__*/React.createElement("table", {
      className: "bx--data-table bx--data-table--short bx--data-table--no-border"
    }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
      className: "bx--data-table--compact"
    }, data.headers.map(res => {
      return /*#__PURE__*/React.createElement("th", {
        key: res.key
      }, res.header.toUpperCase());
    }))), /*#__PURE__*/React.createElement("tbody", null, data.rows.map(res => {
      return /*#__PURE__*/React.createElement("tr", {
        className: "bx--data-table--compact",
        key: res.name
      }, /*#__PURE__*/React.createElement("td", {
        onClick: () => (0, _core.getCurrentTab)().REPL.pexec(res.command)
      }, res.name), /*#__PURE__*/React.createElement("td", null, res.docs));
    })));
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(content), node);
  return node;
};

exports.getTableContent = getTableContent;

const getIntroduction = data => {
  const node = document.createElement('div');

  const content = () => {
    return /*#__PURE__*/React.createElement("div", null, data.map(res => {
      return /*#__PURE__*/React.createElement("div", {
        key: res.header
      }, /*#__PURE__*/React.createElement("h3", {
        className: `${res.header.toLowerCase()}-header`
      }, /*#__PURE__*/React.createElement("strong", null, res.header)), /*#__PURE__*/React.createElement("p", null, res.docs), res.usage ? /*#__PURE__*/React.createElement("div", {
        className: 'bx--snippet bx--snippet--single search'
      }, res.usage, /*#__PURE__*/React.createElement(_iconsReact.Copy24, {
        className: 'copy-btn'
      })) : null);
    }));
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(content), node);
  return node;
};

exports.getIntroduction = getIntroduction;