"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var PropTypes = _interopRequireWildcard(require("prop-types"));

var _core = require("@kui-shell/core");

var _carbonComponentsReact = require("carbon-components-react");

var _iconsReact = require("@carbon/icons-react");

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _HTTPClient = _interopRequireDefault(require("../controller/HTTPClient"));

var _searchQueries = require("../definitions/search-queries");

var _searchHelper = require("../util/search-helper");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

class ResourceModal extends React.PureComponent {
  constructor(props) {
    super(props);
    this.originalInput = false;
    this.state = {
      description: '',
      name: '',
      errors: null,
      open: true
    };
    this.handleDescriptionChange = this.handleDescriptionChange.bind(this);
    this.handleNameChange = this.handleNameChange.bind(this);
  }

  handleDelete() {
    const {
      item
    } = this.props;

    switch (item['kind']) {
      case 'savedSearches':
        (0, _core.getCurrentTab)().REPL.pexec(`search -delete="save" ${item['name']}`);
        this.props.onClose();
        break;

      default:
        (0, _core.getCurrentTab)().REPL.pexec(`search -delete="resource" ${item['name']} ${item['namespace']} ${item['kind']} ${item['cluster']} ${item['selfLink']}`);
        this.props.onClose();
    }
  }

  handleEdit() {
    const {
      item
    } = this.props;
    const data = {
      name: this.state.name,
      description: this.state.description,
      searchText: item['searchText'],
      id: item['id']
    };

    if (!this.state.errors) {
      (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SAVE_SEARCH)(data)).then(() => {
        (0, _core.getCurrentTab)().REPL.pexec(`savedsearches`);
        this.props.onClose();
      }).catch(err => {
        this.setState({
          errors: err
        });
      });
    }
  }

  handleSave() {
    const id = Date.now().toString();
    const data = {
      name: this.state.name,
      description: this.state.description,
      searchText: this.props.item['command'].replace(/search|--save/g, '').trim(),
      id
    };
    const userQuery = (0, _searchHelper.convertStringToQuery)(data.searchText);
    (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SEARCH_RELATED_QUERY)(userQuery.keywords, userQuery.filters)).then(res => {
      if (res.data.searchResult[0].items) {
        (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SAVE_SEARCH)(data)).then(() => {
          this.setState({
            open: false
          });
          (0, _core.getCurrentTab)().REPL.pexec('savedsearches');
        }).catch(err => {
          this.setState({
            errors: err
          });
        });
      }
    }).catch(err => {
      this.setState({
        errors: err
      });
    });
  }

  componentDidUpdate() {
    if (!this.props.modalOpen) {
      this.setState({
        name: '',
        description: '',
        errors: undefined
      });
      this.originalInput = false;
    }

    if (this.props.action === 'edit' && this.props.modalOpen && !this.originalInput) {
      (0, _HTTPClient.default)('post', 'search', _searchQueries.SAVED_SEARCH_QUERY).then(res => {
        const data = res.data.items.filter(item => item.name === this.props.item['name']);

        if (data.length === 0) {
          this.setState({
            errors: (0, _i18n.default)('modal.edit.deleted.search')
          });
        }
      });
      this.setState({
        name: this.props.item['name'],
        description: this.props.item['description']
      });
      this.originalInput = true;
    }
  }

  handleNameChange(event) {
    this.setState({
      name: event.target.value
    });
  }

  handleDescriptionChange(event) {
    this.setState({
      description: event.target.value
    });
  }

  render() {
    const {
      item,
      modalOpen
    } = this.props;
    const bodyLabel = item['kind'];
    let heading = '';

    switch (this.props.action) {
      case 'edit':
        heading = (0, _i18n.default)('modal.query.save.heading');
        break;

      case 'save':
        heading = (0, _i18n.default)('modal.save.title');
        break;

      case 'share':
        heading = (0, _i18n.default)('modal.query.share.heading');
        break;

      case 'remove':
        heading = (0, _i18n.default)('modal.query.delete.heading');
        break;

      default:
        break;
    }

    return /*#__PURE__*/React.createElement(_carbonComponentsReact.Modal, {
      className: this.props.action === 'share' ? 'bx--modal-share' : undefined,
      danger: this.props.action === 'remove',
      id: 'remove-resource-modal',
      open: this.props.action !== 'save' ? modalOpen : this.state.open,
      primaryButtonText: this.props.action === 'remove' ? (0, _i18n.default)('modal.remove-kuberesource.heading') : (0, _i18n.default)('actions.save'),
      primaryButtonDisabled: this.props.action === 'edit' && this.state.name === '' || this.props.action === 'edit' && this.state.name === this.props.item['name'] && this.state.description === this.props.item['description'] || this.props.action === 'save' && this.state.name === '',
      secondaryButtonText: (0, _i18n.default)('modal.button.cancel'),
      modalLabel: bodyLabel ? bodyLabel.toUpperCase() : undefined,
      modalHeading: heading,
      onRequestClose: () => this.props.action !== 'save' ? this.props.onClose() : this.setState({
        open: false
      }),
      onRequestSubmit: () => this.props.action === 'remove' ? this.handleDelete() : this.props.action === 'edit' ? this.handleEdit() : this.handleSave(),
      "aria-label": heading
    }, this.props.action === 'edit' || this.props.action === 'save' ? /*#__PURE__*/React.createElement("div", {
      className: 'bx--action-edit'
    }, this.props.action === 'save' ? /*#__PURE__*/React.createElement("p", {
      className: 'save-text'
    }, (0, _i18n.default)('modal.save.text')) : null, this.state.errors ? /*#__PURE__*/React.createElement("p", {
      className: 'oops save-text-error'
    }, (0, _i18n.default)(this.state.errors)) : null, /*#__PURE__*/React.createElement(_carbonComponentsReact.TextInput, {
      className: 'bx--action-name',
      disabled: false,
      id: 'name',
      labelText: (0, _i18n.default)('modal.query.add.name.label'),
      maxLength: 50,
      type: 'text',
      value: this.state.name,
      onChange: this.handleNameChange,
      placeholder: (0, _i18n.default)('modal.query.add.name')
    }), /*#__PURE__*/React.createElement(_carbonComponentsReact.TextArea, {
      className: 'bx--action-description',
      disabled: false,
      id: 'description',
      labelText: (0, _i18n.default)('modal.query.add.desc.label'),
      maxLength: 140,
      value: this.state.description,
      onChange: this.handleDescriptionChange,
      placeholder: (0, _i18n.default)('modal.query.add.desc')
    })) : null, this.props.action === 'share' ? /*#__PURE__*/React.createElement("div", {
      className: 'bx--action-share'
    }, /*#__PURE__*/React.createElement("p", {
      className: 'copy-description'
    }, (0, _i18n.default)('modal.query.share.name.label')), /*#__PURE__*/React.createElement("div", {
      className: 'bx--snippet bx--snippet--single'
    }, (0, _core.inBrowser)() ? `${window && window.location && window.location.origin}/multicloud/search?filters={"textsearch":"${encodeURIComponent(this.props.item['searchText'])}"}` : `search ${this.props.item['searchText']}`, /*#__PURE__*/React.createElement("button", {
      type: "button",
      className: "bx--copy-btn",
      onClick: () => navigator.clipboard.writeText((0, _core.inBrowser)() ? `${window && window.location && window.location.origin}/multicloud/search?filters={"textsearch":"${encodeURIComponent(this.props.item['searchText'])}"}` : `search ${this.props.item['searchText']}`)
    }, /*#__PURE__*/React.createElement(_iconsReact.Copy24, {
      className: 'copy-btn'
    })))) : null, this.props.action === 'remove' ? /*#__PURE__*/React.createElement("p", null, (0, _i18n.default)('modal.remove.confirm', [item['name']])) : null);
  }

}

exports.default = ResourceModal;
ResourceModal.propTypes = {
  item: PropTypes.object,
  modalOpen: PropTypes.bool
};