"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var PropTypes = _interopRequireWildcard(require("prop-types"));

var _carbonComponentsReact = require("carbon-components-react");

var lodash = _interopRequireWildcard(require("lodash"));

var _HTTPClient = _interopRequireDefault(require("../controller/HTTPClient"));

var _searchQueries = require("../definitions/search-queries");

var _i18n = _interopRequireDefault(require("../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

class Logger extends React.PureComponent {
  constructor(props) {
    super(props);

    this.componentDidMount = () => {
      this.container = this.state.selectedItem;
      this.getLogs();
      this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
    };

    this.componentWillUnmount = () => {
      clearInterval(this.refresh);
    };

    this.isFocused = fn => {
      const focus = document.getElementsByClassName('kui--tab-navigatable kui--notab-when-sidecar-hidden bx--tabs__nav-link');
      document.querySelector('.logs-container__content') && focus[0]['tabIndex'] >= 0 ? fn() : document.querySelector('.visible.sidecar-is-minimized') && document.querySelector('.logs-container__content') ? null : this.componentWillUnmount();
    };

    this.state = {
      selectedItem: lodash.get(this.props.items, '[0]', ''),
      logs: ''
    };
    this.handleOnChange = this.handleOnChange.bind(this);
    this.getLogs = this.getLogs.bind(this);
    this.isFocused = this.isFocused.bind(this);
  }

  handleOnChange(event) {
    this.container = event.selectedItem;
    this.setState({
      logs: ''
    });
    this.getLogs();
    clearInterval(this.refresh);
    this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
  }

  getLogs() {
    if (!document.hidden) {
      const node = document.createElement('div');
      node.classList.add('scrollable');
      node.classList.add('bx--structured-list--summary');
      const record = {
        cluster: this.props.data.cluster,
        container: this.container,
        name: this.props.data.name,
        namespace: this.props.data.namespace
      };
      (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.RESOURCE_LOGS)(record)).then(res => {
        this.setState({
          selectedItem: this.container,
          logs: lodash.get(res, 'data.logs', '') !== null ? res.data.logs : (0, _i18n.default)('search.notfound')
        });
      });
    }
  }

  render() {
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_carbonComponentsReact.Dropdown, {
      titleText: '',
      ariaLabel: '',
      id: 'resource-container-dropdown',
      label: lodash.get(this.props.items, '[0]', ''),
      items: this.props.items,
      onChange: this.handleOnChange
    }), !this.state.logs ? /*#__PURE__*/React.createElement("div", {
      className: 'loading-container'
    }, 'Loading logs') : /*#__PURE__*/React.createElement("div", {
      className: 'logs-container__content'
    }, /*#__PURE__*/React.createElement("pre", null, this.state.logs)));
  }

}

exports.default = Logger;
Logger.propTypes = {
  data: PropTypes.any,
  items: PropTypes.any
};