import { Tab, PreloadRegistrar } from '@kui-shell/core';
import { Channel } from './channel';
/**
 * Return the cached websocket for the given tab
 *
 */
export declare function getChannelForTab(tab: Tab): Channel;
/**
 * Return the session for the given tab
 *
 */
export declare function getSessionForTab(tab: Tab): Promise<Channel>;
/**
 * Keep trying until we can establish a session
 *
 */
export declare function pollUntilOnline(tab: Tab): Promise<unknown>;
/**
 * Initialize per-tab websocket session management
 *
 */
export declare function init(registrar: PreloadRegistrar): Promise<void>;
