import * as React from 'react';
interface Props {
    /** wait this long (millis) before the first update check */
    lag?: number;
    /** periodically check for updates with this interval (millis) */
    interval?: number;
}
interface State {
    /** timer that periodically checks for updates */
    pinger: ReturnType<typeof setInterval>;
    /** version we are running */
    currentVersion: string;
    /** latest version on the release FEED */
    latestVersion: string;
    /** user has acknowledged the given version */
    dulyNoted: string;
}
export default class UpdateChecker extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /** Initialize a timer that periodically checks for updates */
    private initPinger;
    /** Ping the release feed to check for the latest release */
    private checkForUpdates;
    /** What version are we running? */
    private getCurrentVersion;
    componentDidMount(): void;
    /** Bye! */
    componentWillUnmount(): void;
    /** Given current state, is an update available? */
    private isUpdateAvailable;
    /** Text for update available notification */
    private text;
    /** User has acknoledged the notification  */
    private dulyNoted;
    render(): JSX.Element;
}
export {};
