/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Presentation modes
 *
 * Usage:
 *
 * import { Presentation } from '@kui-shell/core'
 *
 * {
 *    type: 'custom',
 *    presentation: Presentation.SidecarFullscreen,
 *    content: ...
 * }
 *
 */
var Presentation;
(function (Presentation) {
    Presentation[Presentation["Default"] = 0] = "Default";
    Presentation[Presentation["FixedSize"] = 1] = "FixedSize";
    Presentation[Presentation["SidecarThin"] = 2] = "SidecarThin";
    Presentation[Presentation["SidecarFullscreen"] = 3] = "SidecarFullscreen";
    Presentation[Presentation["SidecarFullscreenForPopups"] = 4] = "SidecarFullscreenForPopups";
})(Presentation || (Presentation = {}));
export default Presentation;
//# sourceMappingURL=presentation.js.map