import { PrescanModel } from './prescan';
import { KuiPlugin } from '../models/plugin';
import { ThemeSet } from '../webapp/themes/Theme';
/**
 * Scan for plugins incorporated via app/plugins/package.json
 *
 */
declare type Filter = (path: string) => boolean;
export declare const scanForModules: (dir: string, quiet?: boolean, filter?: Filter) => Promise<{
    plugins: Record<string, string>;
    preloads: Record<string, string>;
    themeSets: ThemeSet[];
} | {
    plugins?: undefined;
    preloads?: undefined;
    themeSets?: undefined;
}>;
/**
 * Generate a prescan model
 *
 */
export declare const generatePrescanModel: (registrar: Record<string, KuiPlugin>, opts: PrescanOptions) => Promise<PrescanModel>;
interface PrescanOptions {
    assembly?: boolean;
    pluginRoot?: string;
    externalOnly?: boolean;
}
/**
 * Assemble the plugins for faster loading
 *
 */
export declare const assemble: (registrar: Record<string, KuiPlugin>, opts: PrescanOptions) => Promise<PrescanModel>;
export {};
