/// <reference types="node" />
import { Writable } from 'stream';
import * as colors from 'colors/safe';
import { Row } from '../webapp/models/table';
import { Entity } from '../models/entity';
export declare const setGraphicalShellIsOpen: () => void;
/**
 * Pretty print routine that dispatches to the underlying smarter
 * pretty printers (such as prettyDom and prettyjson)
 *
 */
export declare const print: (msg: string | number | boolean | HTMLElement | Error | {
    content: string;
    contentType: "text/markdown";
} | import("../models/entity").ReactResponse | import("../models/entity").MixedResponse | import("../webapp/models/table").Table<Row> | import("../models/entity").MetadataBearing<void> | import("..").MultiModalResponse<import("../models/entity").MetadataBearing<void>> | import("../models/NavResponse").NavResponse | import("../models/RadioTable").default | import("..").UsageModel | import("../models/entity").RawResponse<void> | import("../models/entity").MetadataBearing<void>[] | Promise<Entity<void, Row, import("../models/entity").MetadataBearing<void>>>, logger?: {
    (message?: any, ...optionalParams: any[]): void;
    (message?: any, ...optionalParams: any[]): void;
}, stream?: Writable, colorFn?: typeof colors.reset, ok?: string) => void | Promise<void>;
