/*
 * Copyright 2017-18 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/**
 * For testing, we sometimes want to disable certain features, to
 * validate error handling.
 *
 */
import Debug from 'debug';
const debug = Debug('core/fuzz-testing');
debug('loading');
/**
 * Block access to a given filepath?
 *
 */
const nope = (filepath) => {
    return filepath.toString().indexOf('.wskprops') >= 0 || filepath.toString().indexOf('.cf/config.json') >= 0;
};
/**
 * Some standard fuzz-testing parameters
 *
 */
const fuzzies = {
    noAuth: () => __awaiter(void 0, void 0, void 0, function* () {
        const fs = require('fs');
        const rf = fs.readFile;
        const rfs = fs.readFileSync;
        fs.readFile = function (filepath, options, cb) {
            if (nope(filepath)) {
                debug('fs.readFile blocked', filepath);
                rf('fjdioafjadisofjadsoifasfsdfjadisfjadisofjasifas', options ? cb : options);
            }
            else {
                if (!cb) {
                    rf(filepath, options);
                }
                else {
                    rf(filepath, options, cb);
                }
            }
        };
        fs.readFileSync = function (filepath, options) {
            if (nope(filepath)) {
                console.error(`fs.readFileSync blocked ${filepath}`);
                return rfs('fjdioafjadisofjadsoifasfsdfjadisfjadisofjasifas');
            }
            else {
                return rfs(filepath, options);
            }
        };
    })
};
export default (_fuzz) => __awaiter(void 0, void 0, void 0, function* () {
    const fuzz = JSON.parse(_fuzz);
    // debug('options', fuzz.rules)
    yield Promise.all((fuzz.rules || []).map((rule) => __awaiter(void 0, void 0, void 0, function* () {
        // intentionally unprotected against failures, because we
        // want the test to fail
        debug('rule', rule);
        yield fuzzies[rule]();
    })));
    return fuzz.prefs;
});
//# sourceMappingURL=fuzz-testing.js.map