"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cellShouldHaveBadge = cellShouldHaveBadge;

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function cellShouldHaveBadge2(hint) {
  return hint === "green-background"
  /* HaveGreenBadge */
  || hint === "red-background"
  /* HaveRedBadge */
  || hint === "yellow-background"
  /* HaveYellowBadge */
  || hint === "gray-background"
  /* HaveGrayBadge */
  ;
}

function cellShouldHaveBadge(hints) {
  if (!hints) {} else if (Array.isArray(hints)) {
    return hints.find(cellShouldHaveBadge2);
  } else if (cellShouldHaveBadge2(hints)) {
    return hints;
  }
}