/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from 'react';
import { v4 as uuid } from 'uuid';
import { radioTableHintsAsCss, radioTableCellToString, cellShouldHaveBadge } from '@kui-shell/core';
import { StructuredListWrapper, StructuredListHead, StructuredListRow, StructuredListCell, StructuredListBody, StructuredListInput } from 'carbon-components-react';
import Icons from '../../Icons';
import { slice } from '../index';
import '../../../../../web/scss/components/RadioTable/Carbon.scss';
export default class CarbonRadioTable extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            uuid: uuid()
        };
    }
    onChange(selectedIdx, onSelect) {
        return __awaiter(this, void 0, void 0, function* () {
            // wow, carbon components isn't so great; we have to manage unchecking ourselves??
            const currentSelection = document.getElementById(this.id(this.props.selectedIdx));
            if (currentSelection) {
                currentSelection.checked = false;
            }
            if (onSelect) {
                yield onSelect();
            }
            this.props.onChange(selectedIdx + this.props.offset);
        });
    }
    id(idx) {
        return `${this.state.uuid}-${idx}`;
    }
    row(row, ridx, head, onSelect) {
        const isSelected = !head && ridx === this.props.selectedIdx - this.props.offset;
        const name = this.id(ridx);
        // notes: label is needed for selection
        return (React.createElement(StructuredListRow, { label: true, head: head, key: ridx, "data-name": row.nameIdx !== undefined ? radioTableCellToString(row.cells[row.nameIdx]) : name, "data-is-selected": isSelected || undefined },
            !head && (React.createElement(StructuredListInput, { defaultChecked: isSelected, id: name, name: name, value: name, onChange: this.onChange.bind(this, ridx, onSelect) })),
            React.createElement(StructuredListCell, null, !head && React.createElement(Icons, { icon: "Checkmark", className: "bx--structured-list-svg" })),
            row.cells.map((cell, cidx) => {
                const badgeHint = cellShouldHaveBadge(cell);
                return (React.createElement(StructuredListCell, { head: head, key: cidx, "data-is-name": cidx === row.nameIdx ? true : undefined, "data-key": typeof cell !== 'string' ? cell.key : undefined, className: radioTableHintsAsCss(cell) },
                    React.createElement("span", { "data-tag": badgeHint ? 'badge' : undefined },
                        badgeHint && React.createElement("span", { "data-tag": "badge-circle", className: badgeHint.toString() }),
                        React.createElement("span", { className: "kui--cell-inner-text" }, radioTableCellToString(cell)))));
            })));
    }
    header() {
        return React.createElement(StructuredListHead, null, this.row(this.props.table.header, 0, true));
    }
    body() {
        return (React.createElement(StructuredListBody, null, slice(this.props).map((row, idx) => this.row(row, idx, false, row.onSelect))));
    }
    render() {
        return (React.createElement(StructuredListWrapper, { selection: true, className: "kui--radio-table kui--table-like" },
            this.header(),
            this.body()));
    }
}
//# sourceMappingURL=Carbon.js.map