/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { KuiContext } from '../../..';
const Carbon = React.lazy(() => import('./impl/Carbon'));
const PatternFly = React.lazy(() => import('./impl/PatternFly'));
export default class Navigation extends React.PureComponent {
    render() {
        return (React.createElement(React.Suspense, { fallback: React.createElement("div", null) },
            React.createElement(KuiContext.Consumer, null, ({ components }) => components === 'patternfly' ? React.createElement(PatternFly, Object.assign({}, this.props)) : React.createElement(Carbon, Object.assign({}, this.props)))));
    }
}
//# sourceMappingURL=index.js.map