import * as React from 'react';
import { CompletionResponse } from '@kui-shell/core';
import { InputProvider as Input } from './Input';
import '../../../../../web/css/static/TabCompletion.scss';
/** User has typed `partial`, and we have `completions` to offer them. */
interface Completions {
    partial: string;
    completions: CompletionResponse[];
}
/**
 * Abstract base class to manage Tab Completion state. This includes
 * asynchronously enumerating the `completions` from a starting
 * `partial. Subclasses will handle both rendering of completion
 * results, and also will direct state transitions.
 *
 */
export declare abstract class TabCompletionState {
    protected readonly input: Input;
    private currentEnumeratorAsync;
    protected readonly lastIdx: number;
    constructor(input: Input);
    protected findCompletions(lastIdx?: number): Promise<Completions>;
    key(event: KeyboardEvent): void;
    protected update(spec: Completions): void;
    protected willUpdate(completions: Completions): boolean;
    private tabAgain;
    done(): void;
    abstract render(): false | React.ReactElement;
}
/**
 * User has hit Tab in an Input component. Should we initialize a tab completion state?
 *
 */
export default function startTabCompletion(input: Input, evt: KeyboardEvent): void;
export {};
