/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { i18n, eventChannelUnsafe } from '@kui-shell/core';
import { Modal } from 'carbon-components-react';
import '../../../web/css/static/Confirm.scss';
const strings = i18n('plugin-core-support');
function isActive(state) {
    return state.isActive;
}
export default class Confirm extends React.PureComponent {
    constructor(props) {
        super(props);
        this.initEvents();
        this.state = {
            isActive: false
        };
    }
    initEvents() {
        const requestChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}`;
        eventChannelUnsafe.on(requestChannel, this.onConfirmStart.bind(this));
    }
    onConfirmStart({ command, asking, execUUID }) {
        this.setState({ isActive: true, command, asking, execUUID });
    }
    /** User has confirmed the command */
    onConfirm(confirmed) {
        if (isActive(this.state)) {
            this.setState({ isActive: false });
            const responseChannel = `/kui-shell/Confirm/v1/tab/${this.props.uuid}/execUUID/${this.state.execUUID}/confirmed`;
            eventChannelUnsafe.emit(responseChannel, { confirmed });
        }
    }
    render() {
        if (!isActive(this.state)) {
            return React.createElement(React.Fragment, null);
        }
        else {
            return (React.createElement(Modal, { id: "confirm-dialog", open: true, danger: true, modalHeading: strings('pleaseConfirm'), primaryButtonText: strings('yesIAmSure'), secondaryButtonText: strings('cancel'), onRequestSubmit: () => this.onConfirm(true), onRequestClose: () => this.onConfirm(false), onSecondarySubmit: () => this.onConfirm(false) },
                React.createElement("p", { className: "bx--modal-content__text" }, strings('aboutToExecute')),
                React.createElement("p", { className: "bx--modal-content__text" },
                    React.createElement("strong", { className: "red-text" }, this.state.command)),
                React.createElement("p", { className: "bx--modal-content__text" }, this.state.asking || strings('areYouSure'))));
        }
    }
}
//# sourceMappingURL=Confirm.js.map