import { Tab, REPL, Table as KuiTable } from '@kui-shell/core';
import * as React from 'react';
import { DataTableHeader } from 'carbon-components-react';
import { Props as ToolbarProps } from './Toolbar';
import { NamedDataTableRow } from './kui2carbon';
import { BreadcrumbView } from '../../spi/Breadcrumb';
/** carbon styling */
import 'carbon-components/scss/components/data-table/_data-table-core.scss';
import 'carbon-components/scss/components/data-table/_data-table-sort.scss';
/** hack (see comments in file) */
import '../../../../web/scss/components/Table/hack-select.scss';
/** import the kui theme alignment */
import '../../../../web/scss/components/Table/carbon-kui-theme-alignment.scss';
import '../../../../web/css/static/ToolbarButton.scss';
import '../../../../web/scss/components/Table/Toolbar.scss';
interface PaginationConfiguration {
    pageSize?: number;
}
/** parameters to PaginatedTable component */
export declare type Props<T extends KuiTable = KuiTable> = PaginationConfiguration & {
    tab: Tab;
    repl: REPL;
    response: T;
    /**
     * paginate: true -> always paginate
     * paginate: false -> never paginate
     * paginate: number -> paginate if above the threshold of rows
     */
    paginate: boolean | number;
    /** use toolbars? */
    toolbars: boolean;
    /** use title? */
    title: boolean;
    /** display as grid (versus as regular table)? */
    asGrid: boolean;
    /** prefix breadcrumbs? */
    prefixBreadcrumbs?: BreadcrumbView[];
};
/** state of PaginatedTable component */
export declare type State = ToolbarProps & {
    headers: DataTableHeader[];
    rows: NamedDataTableRow[];
    page: number;
    pageSize: number;
};
export declare function getBreadcrumbsFromTable(response: KuiTable, prefixBreadcrumbs: BreadcrumbView[]): BreadcrumbView[];
/**
 * A DataTable/Pagination pair
 *
 */
export default class PaginatedTable<P extends Props, S extends State> extends React.PureComponent<P, S> {
    private readonly defaultPageSize;
    constructor(props: P);
    private topToolbar;
    private isPaginated;
    private bottomToolbar;
    private grid;
    private justUpdatedMap;
    private table;
    private content;
    render(): JSX.Element;
}
export {};
