/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import ErrorCell from './ErrorCell';
import { onClickForCell } from './TableCell';
export const findGridableColumn = (response) => {
    return response.body[0] ? response.header.attributes.findIndex(cell => /STATUS|REASON/i.test(cell.key)) : -1;
};
/**
 * A Grid table
 *
 */
export default class Grid extends React.PureComponent {
    render() {
        const { tab, repl, response, visibleRows } = this.props;
        const gridableColumn = findGridableColumn(response);
        const nCells = visibleRows.length;
        const nColumns = Math.ceil(Math.sqrt(nCells));
        const style = { gridTemplateColumns: `repeat(${nColumns}, 1.5rem)` };
        return (React.createElement("div", { className: "bx--data-table kui--data-table-as-grid", style: style }, response.body.map((kuiRow, kidx) => {
            const badgeCell = gridableColumn !== -1 && kuiRow.attributes[gridableColumn];
            const title = `${kuiRow.name}\n${badgeCell ? badgeCell.value : ''}`;
            const css = badgeCell ? badgeCell.css : 'kui--status-unknown';
            // cell label, to be displayed inside of the grid cell
            const label = React.createElement("span", { className: "kui--grid-cell-label" }, kuiRow.name.slice(0, 2));
            const props = {
                title,
                key: kuiRow.attributes[gridableColumn].css,
                'data-tag': 'badge-circle',
                'data-just-updated': this.props.justUpdated[kuiRow.rowKey || kuiRow.name],
                className: css,
                onClick: onClickForCell(kuiRow, tab, repl, kuiRow.attributes.find(_ => _.onclick))
            };
            return (React.createElement("span", { key: kidx, "data-tag": "badge", "data-entity-name": kuiRow.name },
                React.createElement("span", Object.assign({}, props), /red-background/.test(css) ? React.createElement(ErrorCell, null) : label)));
        })));
    }
}
//# sourceMappingURL=Grid.js.map