import * as React from 'react';
import { ScalarResource, SupportedStringContent, FunctionThatProducesContent, ReactProvider, EditableSpec } from '@kui-shell/core';
import { KuiMMRProps } from './KuiContent';
interface EvalProps extends Omit<KuiMMRProps, 'mode'> {
    command: string | FunctionThatProducesContent;
    contentType?: SupportedStringContent;
}
interface EvalState {
    isLoading: boolean;
    command: string | FunctionThatProducesContent;
    react: ReactProvider;
    content: ScalarResource;
    contentType: SupportedStringContent;
    spec?: EditableSpec;
}
/**
 * Notes: asynchronicity in React is a real pain. I realize that
 * `<Suspense />` is supposed to make this easier, but it's still
 * Experimental.
 *
 * What makes this hard: under a given parent component, an `<Eval/>`
 * will only be constructed once, even when the `props` change
 * (i.e. the `constructor` will only be invoked once per parent
 * element). As such, we need to copy the `props.command` to
 * `state.command`, so that we can force a re-eval of the new
 * command. This in turn means we have to manage `state.isLoading`
 * ourselves. Good grief.
 *
 */
export default class Eval extends React.PureComponent<EvalProps, EvalState> {
    constructor(props: EvalProps);
    private startLoading;
    render(): JSX.Element;
}
export {};
