"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _carbonComponentsReact = require("carbon-components-react");

var _HTMLDom = _interopRequireDefault(require("../../Content/Scalar/HTMLDom"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* function isHTMLImage(img: HTMLImageElement | SVGElement): img is HTMLImageElement {
  return (img as HTMLImageElement).alt !== undefined
} */
function oneTimeRender(badgeText) {
  if (typeof badgeText === 'string') {
    return React.createElement(React.Fragment, null, badgeText);
  } else if (badgeText instanceof Element) {
    return React.createElement(_HTMLDom.default, {
      className: "badge-as-image",
      content: badgeText
    });
  } else {
    // otherwise, badge is an IBadgeSpec
    const className = (badgeText.css || '') + (badgeText.onclick ? ' clickable' : '');

    if (badgeText.image) {
      /* // badge is an HTMLImageElement
      if (isHTMLImage(badgeText.image)) {
        badgeText.image.alt = badgeText.title
      }
             return (
          <div data-tag="badge" className={className} ref={badgeText.image}>
          </div>
      )
      badge.appendChild()
      badge.classList.add('badge-as-image') */
      return React.createElement("div", null);
    } else if (badgeText.fontawesome) {
      // badge is a named fontawesome icon
      return React.createElement("div", null);
      /* const awesome = document.createElement('i')
      awesome.className = badgeText.fontawesome
      badge.classList.add('badge-as-fontawesome')
      badge.appendChild(awesome) */
    } else {
      const type = className === 'green-background' ? 'green' : className === 'red-background' ? 'red' : className === 'yellow-background' ? 'warm-gray' : 'gray';
      return React.createElement("div", {
        className: className,
        onClick: () => badgeText.onclick()
      }, React.createElement(_carbonComponentsReact.Tag, {
        type: type
      }, badgeText.title));
    }
  }
}

class Badge extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      cache: oneTimeRender(typeof props.spec === 'function' ? props.spec(props.response, props.tab) : props.spec)
    };
  }

  render() {
    return this.state.cache;
  }

}

exports.default = Badge;