"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const ReactDOM = tslib_1.__importStar(require("react-dom"));
const tippy_js_1 = tslib_1.__importDefault(require("tippy.js"));
// These props are not native to `tippy.js` and are specific to React only.
const REACT_ONLY_PROPS = ['children', 'onCreate', 'isVisible', 'isEnabled'];
/** Avoid Babel's large '_objectWithoutProperties' helper function.
 *
 * @param {object} props - Props object
 */
function getNativeTippyProps(props) {
    return Object.keys(props)
        .filter(prop => !REACT_ONLY_PROPS.includes(prop))
        .reduce((acc, key) => {
        acc[key] = props[key];
        return acc;
    }, {});
}
class PopoverBase extends React.Component {
    constructor() {
        super(...arguments);
        this.state = { isMounted: false };
        this.container = typeof document !== 'undefined' && document.createElement('div');
    }
    get isReactElementContent() {
        return React.isValidElement(this.props.content);
    }
    get options() {
        return Object.assign(Object.assign({}, getNativeTippyProps(this.props)), { content: this.isReactElementContent ? this.container : this.props.content });
    }
    get isManualTrigger() {
        return this.props.trigger === 'manual';
    }
    componentDidMount() {
        this.setState({ isMounted: true });
        /* eslint-disable-next-line */
        this.tip = tippy_js_1.default(ReactDOM.findDOMNode(this), this.options);
        const { onCreate, isEnabled, isVisible } = this.props;
        if (onCreate) {
            onCreate(this.tip);
        }
        if (isEnabled === false) {
            this.tip.disable();
        }
        if (this.isManualTrigger && isVisible === true) {
            this.tip.show();
        }
    }
    componentDidUpdate() {
        this.tip.setProps(this.options);
        const { isEnabled, isVisible } = this.props;
        if (isEnabled === true) {
            this.tip.enable();
        }
        if (isEnabled === false) {
            this.tip.disable();
        }
        if (this.isManualTrigger) {
            if (isVisible === true) {
                this.tip.show();
            }
            if (isVisible === false) {
                this.tip.hide();
            }
        }
    }
    componentWillUnmount() {
        this.tip.destroy();
        this.tip = null;
    }
    render() {
        return (React.createElement(React.Fragment, null,
            this.props.children,
            this.isReactElementContent &&
                this.state.isMounted &&
                ReactDOM.createPortal(this.props.content, this.container)));
    }
}
PopoverBase.defaultProps = {
    trigger: 'mouseenter focus'
};
exports.default = PopoverBase;
//# sourceMappingURL=PopoverBase.js.map