"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmPageProcess = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var AcmPage_1 = require("../AcmPage/AcmPage");
var AcmLoadingPage_1 = require("../AcmLoadingPage/AcmLoadingPage");
var resource_destroyed_svg_1 = __importDefault(require("../assets/resource-destroyed.svg"));
var useStyles = styles_1.makeStyles({
    container: {
        '& .pf-c-card': {
            height: '100vh',
        },
    },
    body: {
        maxWidth: '335px',
        margin: '0 auto',
    },
    image: {
        width: '323px',
        height: '223px',
        marginBottom: '32px',
    },
});
function AcmPageProcess(props) {
    var _a;
    var classes = useStyles();
    if (props.isLoading) {
        return (react_1.default.createElement("div", { className: classes.container },
            react_1.default.createElement(AcmLoadingPage_1.AcmLoadingPage, { title: props.loadingTitle, message: props.loadingMessage, primaryAction: props.loadingPrimaryAction, secondaryActions: props.loadingSecondaryActions })));
    }
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement(AcmPage_1.AcmPageCard, null,
            react_1.default.createElement(react_core_1.EmptyState, null,
                react_1.default.createElement("img", { src: resource_destroyed_svg_1.default, role: "presentation", className: classes.image }),
                react_1.default.createElement("div", { className: classes.body },
                    react_1.default.createElement(react_core_1.Title, { size: "lg", headingLevel: "h4" }, (_a = props.successTitle) !== null && _a !== void 0 ? _a : 'Success'),
                    react_1.default.createElement(react_core_1.EmptyStateBody, null, props.successMessage)),
                props.primaryAction,
                react_1.default.createElement(react_core_1.EmptyStateSecondaryActions, null, props.secondaryActions)))));
}
exports.AcmPageProcess = AcmPageProcess;
//# sourceMappingURL=AcmPageProcess.js.map