"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Splitter = exports.SplitterOrientation = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const splitter_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Splitter/splitter"));
const react_styles_1 = require("@patternfly/react-styles");
var SplitterOrientation;
(function (SplitterOrientation) {
    SplitterOrientation["horizontal"] = "horizontal";
    SplitterOrientation["vertical"] = "vertical";
})(SplitterOrientation = exports.SplitterOrientation || (exports.SplitterOrientation = {}));
const SplitterBase = (_a) => {
    var { className = '', orientation = 'horizontal', innerRef = React.createRef() } = _a, props = tslib_1.__rest(_a, ["className", "orientation", "innerRef"]);
    return (React.createElement("div", Object.assign({ className: react_styles_1.css(splitter_1.default.splitter, orientation === 'vertical' && splitter_1.default.modifiers.vertical, className), role: "separator", tabIndex: 0 }, { 'aria-orientation': orientation }, { ref: innerRef }, props),
        React.createElement("div", { className: react_styles_1.css(splitter_1.default.splitterHandle) })));
};
exports.Splitter = React.forwardRef((props, ref) => (React.createElement(SplitterBase, Object.assign({}, props, { innerRef: ref }))));
exports.Splitter.displayName = 'Splitter';
//# sourceMappingURL=Splitter.js.map