(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = global || self, global.monthSelectPlugin = factory());
}(this, (function () { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? "shorthand" : "longhand"][monthNumber]; };

    function getEventTarget(event) {
        try {
            if (typeof event.composedPath === "function") {
                var path = event.composedPath();
                return path[0];
            }
            return event.target;
        }
        catch (error) {
            return event.target;
        }
    }

    var defaultConfig = {
        shorthand: false,
        dateFormat: "F Y",
        altFormat: "F Y",
        theme: "light",
    };
    function monthSelectPlugin(pluginConfig) {
        var config = __assign(__assign({}, defaultConfig), pluginConfig);
        return function (fp) {
            fp.config.dateFormat = config.dateFormat;
            fp.config.altFormat = config.altFormat;
            var self = { monthsContainer: null };
            function clearUnnecessaryDOMElements() {
                if (!fp.rContainer || !fp.daysContainer || !fp.weekdayContainer)
                    return;
                fp.rContainer.removeChild(fp.daysContainer);
                fp.rContainer.removeChild(fp.weekdayContainer);
                for (var index = 0; index < fp.monthElements.length; index++) {
                    var element = fp.monthElements[index];
                    if (!element.parentNode)
                        continue;
                    element.parentNode.removeChild(element);
                }
            }
            function addListeners() {
                fp._bind(fp.prevMonthNav, "click", function (e) {
                    var _a;
                    e.preventDefault();
                    e.stopPropagation();
                    var selectedMonth = (_a = fp.rContainer) === null || _a === void 0 ? void 0 : _a.querySelector(".flatpickr-monthSelect-month.selected").dateObj.getMonth();
                    if (selectedMonth === 0) {
                        fp.currentYear--;
                    }
                    selectYear();
                });
                fp._bind(fp.nextMonthNav, "click", function (e) {
                    var _a;
                    e.preventDefault();
                    e.stopPropagation();
                    var selectedMonth = (_a = fp.rContainer) === null || _a === void 0 ? void 0 : _a.querySelector(".flatpickr-monthSelect-month.selected").dateObj.getMonth();
                    if (selectedMonth === 11) {
                        fp.currentYear++;
                    }
                    selectYear();
                });
            }
            function addMonths() {
                if (!fp.rContainer)
                    return;
                self.monthsContainer = fp._createElement("div", "flatpickr-monthSelect-months");
                self.monthsContainer.tabIndex = -1;
                fp.calendarContainer.classList.add("flatpickr-monthSelect-theme-" + config.theme);
                for (var i = 0; i < 12; i++) {
                    var month = fp._createElement("span", "flatpickr-monthSelect-month");
                    month.dateObj = new Date(fp.currentYear, i);
                    month.$i = i;
                    month.textContent = monthToStr(i, config.shorthand, fp.l10n);
                    month.tabIndex = -1;
                    month.addEventListener("click", selectMonth);
                    self.monthsContainer.appendChild(month);
                    if ((fp.config.minDate && month.dateObj < fp.config.minDate) ||
                        (fp.config.maxDate && month.dateObj > fp.config.maxDate)) {
                        month.classList.add("disabled");
                    }
                }
                fp.rContainer.appendChild(self.monthsContainer);
            }
            function setCurrentlySelected() {
                if (!fp.rContainer)
                    return;
                var currentlySelected = fp.rContainer.querySelectorAll(".flatpickr-monthSelect-month.selected");
                for (var index = 0; index < currentlySelected.length; index++) {
                    currentlySelected[index].classList.remove("selected");
                }
                var month = fp.rContainer.querySelector(".flatpickr-monthSelect-month:nth-child(" + (fp.currentMonth + 1) + ")");
                if (month) {
                    month.classList.add("selected");
                }
            }
            function selectYear() {
                var selectedDate = fp.selectedDates[0];
                if (selectedDate) {
                    selectedDate = new Date(selectedDate);
                    selectedDate.setFullYear(fp.currentYear);
                    if (fp.config.minDate && selectedDate < fp.config.minDate) {
                        selectedDate = fp.config.minDate;
                    }
                    if (fp.config.maxDate && selectedDate > fp.config.maxDate) {
                        selectedDate = fp.config.maxDate;
                    }
                    fp.currentYear = selectedDate.getFullYear();
                    fp.currentYearElement.value = String(fp.currentYear);
                    fp.currentMonth = selectedDate.getMonth();
                }
                if (fp.rContainer) {
                    var months = fp.rContainer.querySelectorAll(".flatpickr-monthSelect-month");
                    months.forEach(function (month) {
                        month.dateObj.setFullYear(fp.currentYear);
                        if ((fp.config.minDate && month.dateObj < fp.config.minDate) ||
                            (fp.config.maxDate && month.dateObj > fp.config.maxDate)) {
                            month.classList.add("disabled");
                        }
                        else {
                            month.classList.remove("disabled");
                        }
                    });
                }
                setCurrentlySelected();
            }
            function selectMonth(e) {
                e.preventDefault();
                e.stopPropagation();
                var eventTarget = getEventTarget(e);
                if (eventTarget instanceof Element &&
                    !eventTarget.classList.contains("disabled")) {
                    setMonth(eventTarget.dateObj);
                    fp.close();
                }
            }
            function setMonth(date) {
                var selectedDate = new Date(date);
                selectedDate.setFullYear(fp.currentYear);
                fp.currentMonth = selectedDate.getMonth();
                fp.setDate(selectedDate, true);
                setCurrentlySelected();
            }
            var shifts = {
                37: -1,
                39: 1,
                40: 3,
                38: -3,
            };
            function onKeyDown(_, __, ___, e) {
                var shouldMove = shifts[e.keyCode] !== undefined;
                if (!shouldMove && e.keyCode !== 13) {
                    return;
                }
                if (!fp.rContainer || !self.monthsContainer)
                    return;
                var currentlySelected = fp.rContainer.querySelector(".flatpickr-monthSelect-month.selected");
                var index = Array.prototype.indexOf.call(self.monthsContainer.children, document.activeElement);
                if (index === -1) {
                    var target = currentlySelected || self.monthsContainer.firstElementChild;
                    target.focus();
                    index = target.$i;
                }
                if (shouldMove) {
                    self.monthsContainer.children[(12 + index + shifts[e.keyCode]) % 12].focus();
                }
                else if (e.keyCode === 13 &&
                    self.monthsContainer.contains(document.activeElement)) {
                    setMonth(document.activeElement.dateObj);
                }
            }
            function destroyPluginInstance() {
                if (self.monthsContainer !== null) {
                    var months = self.monthsContainer.querySelectorAll(".flatpickr-monthSelect-month");
                    for (var index = 0; index < months.length; index++) {
                        months[index].removeEventListener("click", selectMonth);
                    }
                }
            }
            return {
                onParseConfig: function () {
                    fp.config.mode = "single";
                    fp.config.enableTime = false;
                },
                onValueUpdate: setCurrentlySelected,
                onKeyDown: onKeyDown,
                onReady: [
                    clearUnnecessaryDOMElements,
                    addListeners,
                    addMonths,
                    setCurrentlySelected,
                    function () {
                        fp.loadedPlugins.push("monthSelect");
                    },
                ],
                onDestroy: destroyPluginInstance,
            };
        };
    }

    return monthSelectPlugin;

})));
