export { selectable } from './decorators/selectable';
export { sortable } from './decorators/sortable';
export { cellActions } from './decorators/cellActions';
export { cellWidth } from './decorators/cellWidth';
export { editable } from './decorators/editable';
export { breakWord, fitContent, nowrap, truncate, wrappable } from './decorators/wrappable';
export { textCenter } from './decorators/textCenter';
export { collapsible, expandedRow, expandable } from './decorators/collapsible';
export { compoundExpand } from './decorators/compoundExpand';
export { headerCol } from './decorators/headerCol';
export { classNames, Visibility } from './decorators/classNames';
const emptyTD = () => ({
    scope: '',
    component: 'td'
});
const scopeColTransformer = () => ({
    scope: 'col'
});
const emptyCol = (label) => (Object.assign({}, (label ? {} : { scope: '' })));
const parentId = (_value, { rowData }) => ({
    parentId: rowData.parent
});
const mapProps = (_label, { property, rowData }) => (Object.assign({}, (rowData[property] && rowData[property].props)));
export { emptyTD, scopeColTransformer, emptyCol, parentId, mapProps };
//# sourceMappingURL=transformers.js.map