---
id: Spinner
section: components
cssPrefix: pf-c-spinner
---## Examples

### Basic

```html
<span class="pf-c-spinner" role="progressbar" aria-valuetext="Loading...">
  <span class="pf-c-spinner__clipper"></span>
  <span class="pf-c-spinner__lead-ball"></span>
  <span class="pf-c-spinner__tail-ball"></span>
</span>
```

### Multiple sizes

```html
<span class="pf-c-spinner pf-m-sm" role="progressbar" aria-valuetext="Loading...">
  <span class="pf-c-spinner__clipper"></span>
  <span class="pf-c-spinner__lead-ball"></span>
  <span class="pf-c-spinner__tail-ball"></span>
</span>
<span class="pf-c-spinner pf-m-md" role="progressbar" aria-valuetext="Loading...">
  <span class="pf-c-spinner__clipper"></span>
  <span class="pf-c-spinner__lead-ball"></span>
  <span class="pf-c-spinner__tail-ball"></span>
</span>
<span class="pf-c-spinner pf-m-lg" role="progressbar" aria-valuetext="Loading...">
  <span class="pf-c-spinner__clipper"></span>
  <span class="pf-c-spinner__lead-ball"></span>
  <span class="pf-c-spinner__tail-ball"></span>
</span>
<span class="pf-c-spinner pf-m-xl" role="progressbar" aria-valuetext="Loading...">
  <span class="pf-c-spinner__clipper"></span>
  <span class="pf-c-spinner__lead-ball"></span>
  <span class="pf-c-spinner__tail-ball"></span>
</span>
```

## Documentation

### Accessibility

| Attribute                     | Applied to      | Outcome                                                                               |
| ----------------------------- | --------------- | ------------------------------------------------------------------------------------- |
| `role="progressbar"`          | `.pf-c-spinner` | Indicates to assistive technologies that this is an indeterminate progress indicator. |
| `aria-valuetext="Loading..."` | `.pf-c-spinner` | Describes content that is being loaded, while it is loading.                          |

Note: If the spinner is showing that loading of a particular region of a page is in process, the author should use `aria-describedby` to point to the status, and set the `aria-busy` attribute to `true` on the region until it is finished loading.

Note: A live region must be present before changing its status in order for the change to be read. <https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions>

### Usage

| Class                      | Applied to      | Outcome                                                                          |
| -------------------------- | --------------- | -------------------------------------------------------------------------------- |
| `.pf-c-spinner`            | `<span>`        | Creates a spinner component. The default is an extra large spinner. **Required** |
| `.pf-c-spinner__clipper`   | `<span>`        | Creates the spinning line. **Required**                                          |
| `.pf-c-spinner__lead-ball` | `<span>`        | Rounds out the beginning of the spinning line. **Required**                      |
| `.pf-c-spinner__tail-ball` | `<span>`        | Rounds out the end of the spinning line. **Required**                            |
| `.pf-m-sm`                 | `.pf-c-spinner` | Creates a small spinner.                                                         |
| `.pf-m-md`                 | `.pf-c-spinner` | Creates a medium spinner.                                                        |
| `.pf-m-lg`                 | `.pf-c-spinner` | Creates a large spinner.                                                         |
| `.pf-m-xl`                 | `.pf-c-spinner` | Creates an extra-large spinner.                                                  |
