"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * columns-are-equal.ts
 *
 * Forked from reactabular-table version 8.14.0
 * https://github.com/reactabular/reactabular/tree/v8.14.0/packages/reactabular-table/src
 */
const lodash_1 = require("lodash");
/**
 * @param {ColumnsType} oldColumns - previous columns
 * @param {ColumnsType} newColumns - new columns
 */
function columnsAreEqual(oldColumns, newColumns) {
    return lodash_1.isEqualWith(oldColumns, newColumns, (a, b) => {
        if (lodash_1.isFunction(a) && lodash_1.isFunction(b)) {
            return a === b;
        }
        return undefined;
    });
}
exports.columnsAreEqual = columnsAreEqual;
//# sourceMappingURL=columns-are-equal.js.map