"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
exports.BodyCell = (_a) => {
    var { 'data-label': dataLabel = '', className = '', colSpan, component = 'td', isVisible, parentId, textCenter = false, tooltip: tooltipProp = '', onMouseEnter: onMouseEnterProp = () => { }, children, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    errorText, isValid, isOpen, ariaControls, editableValue, editableSelectProps, options, isSelectOpen, value, name } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = tslib_1.__rest(_a, ['data-label', "className", "colSpan", "component", "isVisible", "parentId", "textCenter", "tooltip", "onMouseEnter", "children", "errorText", "isValid", "isOpen", "ariaControls", "editableValue", "editableSelectProps", "options", "isSelectOpen", "value", "name"]);
    const mappedProps = Object.assign(Object.assign({}, (dataLabel && !parentId ? { 'data-label': dataLabel } : {})), props);
    const [tooltip, setTooltip] = React.useState('');
    const onMouseEnter = (event) => {
        if (event.target.offsetWidth < event.target.scrollWidth) {
            if (tooltipProp) {
                setTooltip(tooltipProp);
            }
            else if (typeof children === 'string') {
                setTooltip(children);
            }
        }
        else {
            setTooltip('');
        }
        onMouseEnterProp(event);
    };
    const Component = component;
    const cell = (React.createElement(Component, Object.assign({}, mappedProps, { onMouseEnter: onMouseEnter, className: react_styles_1.css(className, textCenter && table_1.default.modifiers.center), colSpan: colSpan }), children));
    const bodyCell = tooltip !== '' ? React.createElement(Tooltip_1.Tooltip, { content: tooltip }, cell) : cell;
    return (parentId !== undefined && colSpan === undefined) || !isVisible ? null : bodyCell;
};
exports.BodyCell.displayName = 'BodyCell';
//# sourceMappingURL=BodyCell.js.map