/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IRTransformer = require('../core/IRTransformer');

var SchemaUtils = require('../core/SchemaUtils');

var _require = require('./TransformUtils'),
    hasUnaliasedSelection = _require.hasUnaliasedSelection;

var generateIDField = SchemaUtils.generateIDField;
var ID = 'id';
var NODE_TYPE = 'Node';

/**
 * A transform that adds an `id` field on any type that has an id field but
 * where there is no unaliased `id` selection.
 */
function generateIDFieldTransform(context) {
  var schema = context.getSchema();
  var idType = schema.expectIdType();
  var idField = generateIDField(idType);
  var state = {
    idField: idField
  };
  return IRTransformer.transform(context, {
    LinkedField: visitLinkedField
  }, function () {
    return state;
  });
}

function visitLinkedField(field, state) {
  var transformedNode = this.traverse(field, state); // If the field already has an unaliased `id` field, do nothing

  if (hasUnaliasedSelection(field, ID)) {
    return transformedNode;
  }

  var context = this.getContext();
  var schema = context.getSchema();
  var unmodifiedType = schema.assertCompositeType(schema.getRawType(field.type)); // If the field type has an `id` subfield add an `id` selection

  if (schema.canHaveSelections(unmodifiedType) && schema.hasId(unmodifiedType)) {
    return _objectSpread({}, transformedNode, {
      selections: [].concat((0, _toConsumableArray2["default"])(transformedNode.selections), [state.idField])
    });
  } // If the field type is abstract, then generate a `... on Node { id }`
  // fragment if *any* concrete type implements Node. Then generate a
  // `... on PossibleType { id }` for every concrete type that does *not*
  // implement `Node`


  var nodeType = schema.getTypeFromString(NODE_TYPE);

  if (!nodeType) {
    return transformedNode;
  }

  var nodeInterface = schema.assertInterfaceType(nodeType);

  if (schema.isAbstractType(unmodifiedType)) {
    var selections = (0, _toConsumableArray2["default"])(transformedNode.selections);

    if (schema.mayImplement(unmodifiedType, nodeInterface)) {
      selections.push(buildIDFragment(nodeInterface, state.idField));
    }

    schema.getPossibleTypes(schema.assertAbstractType(unmodifiedType)).forEach(function (possibleType) {
      if (!schema.implementsInterface(schema.assertCompositeType(possibleType), nodeInterface) && schema.hasId(possibleType)) {
        selections.push(buildIDFragment(possibleType, state.idField));
      }
    });
    return _objectSpread({}, transformedNode, {
      selections: selections
    });
  }

  return transformedNode;
}
/**
 * @internal
 *
 * Returns IR for `... on FRAGMENT_TYPE { id }`
 */


function buildIDFragment(fragmentType, idField) {
  return {
    kind: 'InlineFragment',
    directives: [],
    loc: {
      kind: 'Generated'
    },
    metadata: null,
    selections: [idField],
    typeCondition: fragmentType
  };
}

module.exports = {
  transform: generateIDFieldTransform
};