"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("./util");
function filterType(input, ...filters) {
    return filters.some((filter) => filter(input)) ? input : undefined;
}
exports.filterType = filterType;
exports.filterArray = (input) => {
    return Array.isArray(input);
};
exports.filterPrimitives = (input) => {
    return /number|string|boolean/.test(typeof input);
};
exports.filterString = (input) => {
    return typeof input === 'string';
};
exports.filterPlainObject = (input) => {
    return !!input && util_1.objectToString(input) === '[object Object]';
};
exports.filterFunction = (input) => {
    return typeof input === 'function';
};
exports.filterHasLength = (input) => {
    if (input == null) {
        return false;
    }
    const hasLength = typeof input === 'string' || (typeof input === 'object' && ('length' in input));
    return hasLength && typeof input.length === 'number';
};
//# sourceMappingURL=argument-filters.js.map