import { Source, UniversalLoader, DocumentPointerSingle, SchemaPointerSingle, SingleFileOptions } from '@graphql-tools/utils';
export interface GraphQLFileLoaderOptions extends SingleFileOptions {
    skipGraphQLImport?: boolean;
}
export declare class GraphQLFileLoader implements UniversalLoader<GraphQLFileLoaderOptions> {
    loaderId(): string;
    canLoad(pointer: SchemaPointerSingle | DocumentPointerSingle, options: GraphQLFileLoaderOptions): Promise<boolean>;
    canLoadSync(pointer: SchemaPointerSingle | DocumentPointerSingle, options: GraphQLFileLoaderOptions): boolean;
    load(pointer: SchemaPointerSingle | DocumentPointerSingle, options: GraphQLFileLoaderOptions): Promise<Source>;
    loadSync(pointer: SchemaPointerSingle | DocumentPointerSingle, options: GraphQLFileLoaderOptions): Source;
    handleFileContent(rawSDL: string, pointer: string, options: GraphQLFileLoaderOptions): {
        location: string;
        document: import("graphql").DocumentNode;
        rawSDL: string;
    } | {
        location: string;
        document: import("graphql").DocumentNode;
    };
}
