// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/devtools/remoteworkers/v1test2/tasks.proto

package remoteworkers

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// DEPRECATED - use Lease.payload instead.
// A Task represents a unit of work. Its result and logs are defined as
// subresources.
//
// If all the `Any` fields are populated, this can be a very large message, and
// clients may not want the entire message returned on every call to every
// method. Such clients should request partial responses
// (https://cloud.google.com/apis/design/design_patterns#partial_response) and
// servers should implement partial responses in order to reduce unnecessry
// overhead.
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this task. Output only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The actual task to perform. For example, this could be CommandTask to run a
	// command line.
	Description *any.Any `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Handles to logs. The key is a human-readable name like `stdout`, and the
	// handle is a resource name that can be passed to ByteStream or other
	// accessors.
	//
	// An implementation may define some logs by default (like `stdout`), and may
	// allow clients to add new logs via AddTaskLog.
	Logs map[string]string `protobuf:"bytes,3,rep,name=logs,proto3" json:"logs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{0}
}

func (x *Task) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Task) GetDescription() *any.Any {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *Task) GetLogs() map[string]string {
	if x != nil {
		return x.Logs
	}
	return nil
}

// DEPRECATED - use Lease.assignment_result instead.
// The result and metadata of the task.
type TaskResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The result may be updated several times; the client must only set
	// `complete` to true to indicate that no further updates are allowed.
	// If this is not true, the `status` field must not be examined since its zero
	// value is equivalent to `OK`.
	//
	// Once a task is completed, it must not be updated with further results,
	// though the implementation may choose to continue to receive logs.
	Complete bool `protobuf:"varint,2,opt,name=complete,proto3" json:"complete,omitempty"`
	// The final status of the task itself. For example, if task.description
	// included a timeout which was violated, status.code may be
	// DEADLINE_EXCEEDED. This field can only be read if `complete` is true.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// Any non-log output, such as output files and exit codes. See
	// CommandResult as an example.
	Output *any.Any `protobuf:"bytes,4,opt,name=output,proto3" json:"output,omitempty"`
	// Any information about how the command was executed, eg runtime. See
	// CommandOverhead as an example.
	Meta *any.Any `protobuf:"bytes,5,opt,name=meta,proto3" json:"meta,omitempty"`
}

func (x *TaskResult) Reset() {
	*x = TaskResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskResult) ProtoMessage() {}

func (x *TaskResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskResult.ProtoReflect.Descriptor instead.
func (*TaskResult) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{1}
}

func (x *TaskResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TaskResult) GetComplete() bool {
	if x != nil {
		return x.Complete
	}
	return false
}

func (x *TaskResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TaskResult) GetOutput() *any.Any {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *TaskResult) GetMeta() *any.Any {
	if x != nil {
		return x.Meta
	}
	return nil
}

// Request message for `GetTask`.
type GetTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The task name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTaskRequest) Reset() {
	*x = GetTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTaskRequest) ProtoMessage() {}

func (x *GetTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTaskRequest.ProtoReflect.Descriptor instead.
func (*GetTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{2}
}

func (x *GetTaskRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `UpdateTaskResult`.
type UpdateTaskResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The task result name; must match `result.name`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The result being updated.
	Result *TaskResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Required. The fields within `result` that are specified.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. If this is being updated by a bot from BotManager, the source should be
	// bot.session_id. That way, if two bots accidentally get the same name, we'll
	// know to reject updates from the older one.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *UpdateTaskResultRequest) Reset() {
	*x = UpdateTaskResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTaskResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTaskResultRequest) ProtoMessage() {}

func (x *UpdateTaskResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTaskResultRequest.ProtoReflect.Descriptor instead.
func (*UpdateTaskResultRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateTaskResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateTaskResultRequest) GetResult() *TaskResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *UpdateTaskResultRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTaskResultRequest) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

// Request message for `AddTaskLog`.
type AddTaskLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the task that will own the new log.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the log, like `stdout` or a relative file path.
	LogId string `protobuf:"bytes,2,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
}

func (x *AddTaskLogRequest) Reset() {
	*x = AddTaskLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTaskLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTaskLogRequest) ProtoMessage() {}

func (x *AddTaskLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTaskLogRequest.ProtoReflect.Descriptor instead.
func (*AddTaskLogRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{4}
}

func (x *AddTaskLogRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddTaskLogRequest) GetLogId() string {
	if x != nil {
		return x.LogId
	}
	return ""
}

// Response message for `AddTaskLog`.
type AddTaskLogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The handle for the new log, as would be returned in Task.logs.
	Handle string `protobuf:"bytes,1,opt,name=handle,proto3" json:"handle,omitempty"`
}

func (x *AddTaskLogResponse) Reset() {
	*x = AddTaskLogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTaskLogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTaskLogResponse) ProtoMessage() {}

func (x *AddTaskLogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTaskLogResponse.ProtoReflect.Descriptor instead.
func (*AddTaskLogResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP(), []int{5}
}

func (x *AddTaskLogResponse) GetHandle() string {
	if x != nil {
		return x.Handle
	}
	return ""
}

var File_google_devtools_remoteworkers_v1test2_tasks_proto protoreflect.FileDescriptor

var file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x9e, 0x02, 0x0a, 0x04, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x36, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x04, 0x6c, 0x6f, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x54,
	0x61, 0x73, 0x6b, 0x2e, 0x4c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6c,
	0x6f, 0x67, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x46, 0xea, 0x41,
	0x43, 0x0a, 0x21, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x73, 0x6b, 0x12, 0x1e, 0x7b, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b, 0x74,
	0x61, 0x73, 0x6b, 0x7d, 0x22, 0x95, 0x02, 0x0a, 0x0a, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x2c, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x28, 0x0a,
	0x04, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x3a, 0x53, 0xea, 0x41, 0x50, 0x0a, 0x27, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x25, 0x7b, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x3d, 0x2a, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b,
	0x74, 0x61, 0x73, 0x6b, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x4f, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8d, 0x02,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4e,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x6e, 0x0a,
	0x11, 0x41, 0x64, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x22, 0x2c, 0x0a,
	0x12, 0x41, 0x64, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x32, 0xdf, 0x04, 0x0a, 0x05,
	0x54, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73,
	0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32,
	0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a,
	0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xd9, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x32, 0x21, 0x2f, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x2a, 0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x7d, 0x3a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0xda, 0x41, 0x1e, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xbd, 0x01, 0x0a,
	0x0a, 0x41, 0x64, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65,
	0x73, 0x74, 0x32, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x41, 0x64,
	0x64, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x74, 0x65, 0x73,
	0x74, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x4c, 0x6f, 0x67, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x1a, 0x1f, 0xca, 0x41,
	0x1c, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xc2, 0x01,
	0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x42, 0x12, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x50,
	0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0xa2, 0x02, 0x02, 0x52, 0x57, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x76, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x56, 0x31, 0x54, 0x65, 0x73,
	0x74, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescOnce sync.Once
	file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescData = file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDesc
)

func file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescGZIP() []byte {
	file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescOnce.Do(func() {
		file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescData)
	})
	return file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDescData
}

var file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_devtools_remoteworkers_v1test2_tasks_proto_goTypes = []interface{}{
	(*Task)(nil),                    // 0: google.devtools.remoteworkers.v1test2.Task
	(*TaskResult)(nil),              // 1: google.devtools.remoteworkers.v1test2.TaskResult
	(*GetTaskRequest)(nil),          // 2: google.devtools.remoteworkers.v1test2.GetTaskRequest
	(*UpdateTaskResultRequest)(nil), // 3: google.devtools.remoteworkers.v1test2.UpdateTaskResultRequest
	(*AddTaskLogRequest)(nil),       // 4: google.devtools.remoteworkers.v1test2.AddTaskLogRequest
	(*AddTaskLogResponse)(nil),      // 5: google.devtools.remoteworkers.v1test2.AddTaskLogResponse
	nil,                             // 6: google.devtools.remoteworkers.v1test2.Task.LogsEntry
	(*any.Any)(nil),                 // 7: google.protobuf.Any
	(*status.Status)(nil),           // 8: google.rpc.Status
	(*field_mask.FieldMask)(nil),    // 9: google.protobuf.FieldMask
}
var file_google_devtools_remoteworkers_v1test2_tasks_proto_depIdxs = []int32{
	7,  // 0: google.devtools.remoteworkers.v1test2.Task.description:type_name -> google.protobuf.Any
	6,  // 1: google.devtools.remoteworkers.v1test2.Task.logs:type_name -> google.devtools.remoteworkers.v1test2.Task.LogsEntry
	8,  // 2: google.devtools.remoteworkers.v1test2.TaskResult.status:type_name -> google.rpc.Status
	7,  // 3: google.devtools.remoteworkers.v1test2.TaskResult.output:type_name -> google.protobuf.Any
	7,  // 4: google.devtools.remoteworkers.v1test2.TaskResult.meta:type_name -> google.protobuf.Any
	1,  // 5: google.devtools.remoteworkers.v1test2.UpdateTaskResultRequest.result:type_name -> google.devtools.remoteworkers.v1test2.TaskResult
	9,  // 6: google.devtools.remoteworkers.v1test2.UpdateTaskResultRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 7: google.devtools.remoteworkers.v1test2.Tasks.GetTask:input_type -> google.devtools.remoteworkers.v1test2.GetTaskRequest
	3,  // 8: google.devtools.remoteworkers.v1test2.Tasks.UpdateTaskResult:input_type -> google.devtools.remoteworkers.v1test2.UpdateTaskResultRequest
	4,  // 9: google.devtools.remoteworkers.v1test2.Tasks.AddTaskLog:input_type -> google.devtools.remoteworkers.v1test2.AddTaskLogRequest
	0,  // 10: google.devtools.remoteworkers.v1test2.Tasks.GetTask:output_type -> google.devtools.remoteworkers.v1test2.Task
	1,  // 11: google.devtools.remoteworkers.v1test2.Tasks.UpdateTaskResult:output_type -> google.devtools.remoteworkers.v1test2.TaskResult
	5,  // 12: google.devtools.remoteworkers.v1test2.Tasks.AddTaskLog:output_type -> google.devtools.remoteworkers.v1test2.AddTaskLogResponse
	10, // [10:13] is the sub-list for method output_type
	7,  // [7:10] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_devtools_remoteworkers_v1test2_tasks_proto_init() }
func file_google_devtools_remoteworkers_v1test2_tasks_proto_init() {
	if File_google_devtools_remoteworkers_v1test2_tasks_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTaskResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTaskLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTaskLogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_remoteworkers_v1test2_tasks_proto_goTypes,
		DependencyIndexes: file_google_devtools_remoteworkers_v1test2_tasks_proto_depIdxs,
		MessageInfos:      file_google_devtools_remoteworkers_v1test2_tasks_proto_msgTypes,
	}.Build()
	File_google_devtools_remoteworkers_v1test2_tasks_proto = out.File
	file_google_devtools_remoteworkers_v1test2_tasks_proto_rawDesc = nil
	file_google_devtools_remoteworkers_v1test2_tasks_proto_goTypes = nil
	file_google_devtools_remoteworkers_v1test2_tasks_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TasksClient is the client API for Tasks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TasksClient interface {
	// DEPRECATED - use Lease.payload instead.
	// GetTask reads the current state of the task. Tasks must be created through
	// some other interface, and should be immutable once created and exposed to
	// the bots.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// DEPRECATED - use Lease.result instead.
	// UpdateTaskResult updates the result.
	UpdateTaskResult(ctx context.Context, in *UpdateTaskResultRequest, opts ...grpc.CallOption) (*TaskResult, error)
	// DEPRECATED - precreate logs prior to sending to bot.
	// AddTaskLog creates a new streaming log. The log is streamed and marked as
	// completed through other interfaces (i.e., ByteStream). This can be called
	// by the bot if it wants to create a new log; the server can also predefine
	// logs that do not need to be created (e.g. `stdout`).
	AddTaskLog(ctx context.Context, in *AddTaskLogRequest, opts ...grpc.CallOption) (*AddTaskLogResponse, error)
}

type tasksClient struct {
	cc grpc.ClientConnInterface
}

func NewTasksClient(cc grpc.ClientConnInterface) TasksClient {
	return &tasksClient{cc}
}

func (c *tasksClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/GetTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tasksClient) UpdateTaskResult(ctx context.Context, in *UpdateTaskResultRequest, opts ...grpc.CallOption) (*TaskResult, error) {
	out := new(TaskResult)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/UpdateTaskResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tasksClient) AddTaskLog(ctx context.Context, in *AddTaskLogRequest, opts ...grpc.CallOption) (*AddTaskLogResponse, error) {
	out := new(AddTaskLogResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/AddTaskLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TasksServer is the server API for Tasks service.
type TasksServer interface {
	// DEPRECATED - use Lease.payload instead.
	// GetTask reads the current state of the task. Tasks must be created through
	// some other interface, and should be immutable once created and exposed to
	// the bots.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// DEPRECATED - use Lease.result instead.
	// UpdateTaskResult updates the result.
	UpdateTaskResult(context.Context, *UpdateTaskResultRequest) (*TaskResult, error)
	// DEPRECATED - precreate logs prior to sending to bot.
	// AddTaskLog creates a new streaming log. The log is streamed and marked as
	// completed through other interfaces (i.e., ByteStream). This can be called
	// by the bot if it wants to create a new log; the server can also predefine
	// logs that do not need to be created (e.g. `stdout`).
	AddTaskLog(context.Context, *AddTaskLogRequest) (*AddTaskLogResponse, error)
}

// UnimplementedTasksServer can be embedded to have forward compatible implementations.
type UnimplementedTasksServer struct {
}

func (*UnimplementedTasksServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (*UnimplementedTasksServer) UpdateTaskResult(context.Context, *UpdateTaskResultRequest) (*TaskResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateTaskResult not implemented")
}
func (*UnimplementedTasksServer) AddTaskLog(context.Context, *AddTaskLogRequest) (*AddTaskLogResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddTaskLog not implemented")
}

func RegisterTasksServer(s *grpc.Server, srv TasksServer) {
	s.RegisterService(&_Tasks_serviceDesc, srv)
}

func _Tasks_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tasks_UpdateTaskResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).UpdateTaskResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/UpdateTaskResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).UpdateTaskResult(ctx, req.(*UpdateTaskResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tasks_AddTaskLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTaskLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).AddTaskLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/AddTaskLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).AddTaskLog(ctx, req.(*AddTaskLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Tasks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteworkers.v1test2.Tasks",
	HandlerType: (*TasksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTask",
			Handler:    _Tasks_GetTask_Handler,
		},
		{
			MethodName: "UpdateTaskResult",
			Handler:    _Tasks_UpdateTaskResult_Handler,
		},
		{
			MethodName: "AddTaskLog",
			Handler:    _Tasks_AddTaskLog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteworkers/v1test2/tasks.proto",
}
