/// <reference types="react" />
import React from 'react';
import { ReactElement } from 'react';
export declare type ChildrenFn<P> = (props: P) => JSX.Element | null;
export declare type RPC<RP, P = {}> = React.ComponentType<P & {
    children?: ChildrenFn<RP>;
    render?: ChildrenFn<RP>;
}>;
export declare type MapperComponent<RP, P> = React.ComponentType<RP & P & {
    render?: ChildrenFn<any>;
}>;
export declare type MapperValue<RP, P> = ReactElement<any> | MapperComponent<RP, P>;
export declare type Mapper<RP, P> = Record<string, MapperValue<RP, P>>;
export declare type MapProps<RP> = (props: any) => RP;
export declare function adopt<RP = any, P = any>(mapper: Mapper<RP, P>, mapProps?: MapProps<RP>): RPC<RP, P>;
export declare type AdoptProps<RP, P> = P & {
    mapper: Mapper<RP, P>;
    children?: ChildrenFn<RP>;
    render?: ChildrenFn<RP>;
    mapProps?: MapProps<RP>;
};
export declare class Adopt extends React.Component<AdoptProps<any, any>> {
    private Composed;
    constructor(props: any);
    render(): JSX.Element;
}
